/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional;

import java.util.Iterator;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.delegates.TriFunction;
import net.emaze.dysfunctional.interceptions.BinaryInterceptor;
import net.emaze.dysfunctional.interceptions.BinaryInterceptorChain;
import net.emaze.dysfunctional.interceptions.Interceptor;
import net.emaze.dysfunctional.interceptions.InterceptorChain;
import net.emaze.dysfunctional.interceptions.TernaryInterceptor;
import net.emaze.dysfunctional.interceptions.TernaryInterceptorChain;
import net.emaze.dysfunctional.iterations.ArrayIterator;
import net.emaze.dysfunctional.iterations.SingletonIterator;

public abstract class Interceptors {
    public static <T, R> Function<T, R> intercept(Function<T, R> innermost, Interceptor<T> interceptor) {
        dbc.precondition(interceptor != null, "cannot create an interceptor chain with a null interceptor", new Object[0]);
        return new InterceptorChain<T, R>(innermost, new SingletonIterator<Interceptor<T>>(interceptor));
    }

    public static <T, R> Function<T, R> intercept(Function<T, R> innermost, Interceptor<T> first, Interceptor<T> second) {
        dbc.precondition(first != null, "cannot create an interceptor chain with a null interceptor", new Object[0]);
        dbc.precondition(second != null, "cannot create an interceptor chain with a null interceptor", new Object[0]);
        ArrayIterator<Interceptor> interceptors = ArrayIterator.of(first, second);
        return new InterceptorChain<T, R>(innermost, interceptors);
    }

    public static <T, R> Function<T, R> intercept(Function<T, R> innermost, Interceptor<T> first, Interceptor<T> second, Interceptor<T> third) {
        dbc.precondition(first != null, "cannot create an interceptor chain with a null interceptor", new Object[0]);
        dbc.precondition(second != null, "cannot create an interceptor chain with a null interceptor", new Object[0]);
        dbc.precondition(third != null, "cannot create an interceptor chain with a null interceptor", new Object[0]);
        ArrayIterator<Interceptor> interceptors = ArrayIterator.of(first, second, third);
        return new InterceptorChain<T, R>(innermost, interceptors);
    }

    public static <T, R, I extends Interceptor<T>> Function<T, R> intercept(Function<T, R> innermost, Iterable<I> interceptors) {
        dbc.precondition(interceptors != null, "cannot create an interceptor chain with a null iterable of interceptors", new Object[0]);
        return new InterceptorChain<T, R>(innermost, interceptors.iterator());
    }

    public static <T, R, I extends Interceptor<T>> Function<T, R> intercept(Function<T, R> innermost, Iterator<I> interceptors) {
        return new InterceptorChain<T, R>(innermost, interceptors);
    }

    public static <T, R> Function<T, R> intercept(Function<T, R> innermost, Interceptor<T> ... interceptors) {
        return new InterceptorChain<T, R>(innermost, new ArrayIterator<Interceptor<T>>(interceptors));
    }

    public static <T1, T2, R> BiFunction<T1, T2, R> intercept(BiFunction<T1, T2, R> innermost, BinaryInterceptor<T1, T2> interceptor) {
        dbc.precondition(interceptor != null, "cannot create an interceptor chain with a null interceptor", new Object[0]);
        return new BinaryInterceptorChain<T1, T2, R>(innermost, new SingletonIterator<BinaryInterceptor<T1, T2>>(interceptor));
    }

    public static <T1, T2, R> BiFunction<T1, T2, R> intercept(BiFunction<T1, T2, R> innermost, BinaryInterceptor<T1, T2> first, BinaryInterceptor<T1, T2> second) {
        dbc.precondition(first != null, "cannot create an interceptor chain with a null interceptor", new Object[0]);
        dbc.precondition(second != null, "cannot create an interceptor chain with a null interceptor", new Object[0]);
        ArrayIterator<BinaryInterceptor> interceptors = ArrayIterator.of(first, second);
        return new BinaryInterceptorChain<T1, T2, R>(innermost, interceptors);
    }

    public static <T1, T2, R> BiFunction<T1, T2, R> intercept(BiFunction<T1, T2, R> innermost, BinaryInterceptor<T1, T2> first, BinaryInterceptor<T1, T2> second, BinaryInterceptor<T1, T2> third) {
        dbc.precondition(first != null, "cannot create an interceptor chain with a null interceptor", new Object[0]);
        dbc.precondition(second != null, "cannot create an interceptor chain with a null interceptor", new Object[0]);
        dbc.precondition(third != null, "cannot create an interceptor chain with a null interceptor", new Object[0]);
        ArrayIterator<BinaryInterceptor> interceptors = ArrayIterator.of(first, second, third);
        return new BinaryInterceptorChain<T1, T2, R>(innermost, interceptors);
    }

    public static <T1, T2, I extends BinaryInterceptor<T1, T2>, R> BiFunction<T1, T2, R> intercept(BiFunction<T1, T2, R> innermost, Iterable<I> interceptors) {
        dbc.precondition(interceptors != null, "cannot create an interceptor chain with a null iterable of interceptors", new Object[0]);
        return new BinaryInterceptorChain<T1, T2, R>(innermost, interceptors.iterator());
    }

    public static <T1, T2, I extends BinaryInterceptor<T1, T2>, R> BiFunction<T1, T2, R> intercept(BiFunction<T1, T2, R> innermost, Iterator<I> interceptors) {
        return new BinaryInterceptorChain<T1, T2, R>(innermost, interceptors);
    }

    public static <T1, T2, R> BiFunction<T1, T2, R> intercept(BiFunction<T1, T2, R> innermost, BinaryInterceptor<T1, T2> ... interceptors) {
        return new BinaryInterceptorChain<T1, T2, R>(innermost, new ArrayIterator<BinaryInterceptor<T1, T2>>(interceptors));
    }

    public static <T1, T2, T3, R> TriFunction<T1, T2, T3, R> intercept(TriFunction<T1, T2, T3, R> innermost, TernaryInterceptor<T1, T2, T3> interceptor) {
        dbc.precondition(interceptor != null, "cannot create an interceptor chain with a null interceptor", new Object[0]);
        return new TernaryInterceptorChain<T1, T2, T3, R>(innermost, new SingletonIterator<TernaryInterceptor<T1, T2, T3>>(interceptor));
    }

    public static <T1, T2, T3, R> TriFunction<T1, T2, T3, R> intercept(TriFunction<T1, T2, T3, R> innermost, TernaryInterceptor<T1, T2, T3> first, TernaryInterceptor<T1, T2, T3> second) {
        dbc.precondition(first != null, "cannot create an interceptor chain with a null interceptor", new Object[0]);
        dbc.precondition(second != null, "cannot create an interceptor chain with a null interceptor", new Object[0]);
        ArrayIterator<TernaryInterceptor> interceptors = ArrayIterator.of(first, second);
        return new TernaryInterceptorChain<T1, T2, T3, R>(innermost, interceptors);
    }

    public static <T1, T2, T3, R> TriFunction<T1, T2, T3, R> intercept(TriFunction<T1, T2, T3, R> innermost, TernaryInterceptor<T1, T2, T3> first, TernaryInterceptor<T1, T2, T3> second, TernaryInterceptor<T1, T2, T3> third) {
        dbc.precondition(first != null, "cannot create an interceptor chain with a null interceptor", new Object[0]);
        dbc.precondition(second != null, "cannot create an interceptor chain with a null interceptor", new Object[0]);
        dbc.precondition(third != null, "cannot create an interceptor chain with a null interceptor", new Object[0]);
        ArrayIterator<TernaryInterceptor> interceptors = ArrayIterator.of(first, second, third);
        return new TernaryInterceptorChain<T1, T2, T3, R>(innermost, interceptors);
    }

    public static <R, T1, T2, T3, I extends TernaryInterceptor<T1, T2, T3>> TriFunction<T1, T2, T3, R> intercept(TriFunction<T1, T2, T3, R> innermost, Iterable<I> interceptors) {
        dbc.precondition(interceptors != null, "cannot create an interceptor chain with a null iterable of interceptors", new Object[0]);
        return new TernaryInterceptorChain<T1, T2, T3, R>(innermost, interceptors.iterator());
    }

    public static <R, T1, T2, T3, I extends TernaryInterceptor<T1, T2, T3>> TriFunction<T1, T2, T3, R> intercept(TriFunction<T1, T2, T3, R> innermost, Iterator<I> interceptors) {
        return new TernaryInterceptorChain<T1, T2, T3, R>(innermost, interceptors);
    }

    public static <T1, T2, T3, R> TriFunction<T1, T2, T3, R> intercept(TriFunction<T1, T2, T3, R> innermost, TernaryInterceptor<T1, T2, T3> ... interceptors) {
        return new TernaryInterceptorChain<T1, T2, T3, R>(innermost, new ArrayIterator<TernaryInterceptor<T1, T2, T3>>(interceptors));
    }
}

