/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.emaze.dysfunctional.Compositions;
import net.emaze.dysfunctional.casts.Vary;
import net.emaze.dysfunctional.collections.ArrayListFactory;
import net.emaze.dysfunctional.collections.HashMapFactory;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.groups.GroupBy;
import net.emaze.dysfunctional.groups.IndexBy;
import net.emaze.dysfunctional.groups.PartitionBy;
import net.emaze.dysfunctional.iterations.ArrayIterator;
import net.emaze.dysfunctional.tuples.Pair;

public abstract class Groups {
    public static <K, V> Map<K, List<V>> groupBy(Iterator<V> groupies, Function<V, K> grouper) {
        Supplier supplier = Compositions.compose(new Vary(), new ArrayListFactory());
        return new GroupBy(grouper, supplier, new HashMapFactory()).apply(groupies);
    }

    public static <K, V, C extends Collection<V>> Map<K, C> groupBy(Iterator<V> groupies, Function<V, K> grouper, Supplier<C> collectionProvider) {
        return new GroupBy(grouper, collectionProvider, new HashMapFactory()).apply(groupies);
    }

    public static <K, V, C extends Collection<V>, M extends Map<K, C>> Map<K, C> groupBy(Iterator<V> groupies, Function<V, K> grouper, Supplier<C> collectionProvider, Supplier<M> mapProvider) {
        return new GroupBy<M, C, K, V>(grouper, collectionProvider, mapProvider).apply(groupies);
    }

    public static <K, V> Map<K, List<V>> groupBy(Iterable<V> groupies, Function<V, K> grouper) {
        dbc.precondition(groupies != null, "cannot group a null iterable", new Object[0]);
        Supplier supplier = Compositions.compose(new Vary(), new ArrayListFactory());
        return new GroupBy(grouper, supplier, new HashMapFactory()).apply(groupies.iterator());
    }

    public static <K, V, C extends Collection<V>> Map<K, C> groupBy(Iterable<V> groupies, Function<V, K> grouper, Supplier<C> collectionProvider) {
        dbc.precondition(groupies != null, "cannot group a null iterable", new Object[0]);
        return new GroupBy(grouper, collectionProvider, new HashMapFactory()).apply(groupies.iterator());
    }

    public static <K, V, C extends Collection<V>, M extends Map<K, C>> Map<K, C> groupBy(Iterable<V> groupies, Function<V, K> grouper, Supplier<C> collectionProvider, Supplier<M> mapProvider) {
        dbc.precondition(groupies != null, "cannot group a null iterable", new Object[0]);
        return new GroupBy<M, C, K, V>(grouper, collectionProvider, mapProvider).apply(groupies.iterator());
    }

    public static <K, V> Map<K, List<V>> groupBy(V[] groupies, Function<V, K> grouper) {
        Supplier supplier = Compositions.compose(new Vary(), new ArrayListFactory());
        return new GroupBy(grouper, supplier, new HashMapFactory()).apply((Iterator<V>)new ArrayIterator<V>(groupies));
    }

    public static <K, V, C extends Collection<V>> Map<K, C> groupBy(V[] groupies, Function<V, K> grouper, Supplier<C> collectionProvider) {
        return new GroupBy(grouper, collectionProvider, new HashMapFactory()).apply((Iterator<V>)new ArrayIterator<V>(groupies));
    }

    public static <K, V, C extends Collection<V>, M extends Map<K, C>> Map<K, C> groupBy(V[] groupies, Function<V, K> grouper, Supplier<C> collectionProvider, Supplier<M> mapProvider) {
        return new GroupBy<M, C, K, V>(grouper, collectionProvider, mapProvider).apply((Iterator<V>)new ArrayIterator<V>(groupies));
    }

    public static <T> Pair<List<T>, List<T>> partition(Iterator<T> values, Predicate<T> partitioner) {
        Supplier supplier = Compositions.compose(new Vary(), new ArrayListFactory());
        return new PartitionBy(partitioner, supplier, supplier).apply(values);
    }

    public static <T, C extends Collection<T>> Pair<C, C> partition(Iterator<T> values, Predicate<T> partitioner, Supplier<C> collectionsProvider) {
        return new PartitionBy<T, C, C>(partitioner, collectionsProvider, collectionsProvider).apply(values);
    }

    public static <T, CA extends Collection<T>, CR extends Collection<T>> Pair<CA, CR> partition(Iterator<T> values, Predicate<T> partitioner, Supplier<CA> acceptedCollectionProvider, Supplier<CR> refusedCollectionProvider) {
        return new PartitionBy<T, CA, CR>(partitioner, acceptedCollectionProvider, refusedCollectionProvider).apply(values);
    }

    public static <T> Pair<List<T>, List<T>> partition(Iterable<T> values, Predicate<T> partitioner) {
        dbc.precondition(values != null, "cannot partition a null iterable", new Object[0]);
        Supplier supplier = Compositions.compose(new Vary(), new ArrayListFactory());
        return new PartitionBy(partitioner, supplier, supplier).apply(values.iterator());
    }

    public static <T, C extends Collection<T>> Pair<C, C> partition(Iterable<T> values, Predicate<T> partitioner, Supplier<C> collectionsProvider) {
        dbc.precondition(values != null, "cannot partition a null iterable", new Object[0]);
        return new PartitionBy<T, C, C>(partitioner, collectionsProvider, collectionsProvider).apply(values.iterator());
    }

    public static <T, CA extends Collection<T>, CR extends Collection<T>> Pair<CA, CR> partition(Iterable<T> values, Predicate<T> partitioner, Supplier<CA> acceptedCollectionProvider, Supplier<CR> refusedCollectionProvider) {
        dbc.precondition(values != null, "cannot partition a null iterable", new Object[0]);
        return new PartitionBy<T, CA, CR>(partitioner, acceptedCollectionProvider, refusedCollectionProvider).apply(values.iterator());
    }

    public static <T> Pair<List<T>, List<T>> partition(T[] values, Predicate<T> partitioner) {
        Supplier supplier = Compositions.compose(new Vary(), new ArrayListFactory());
        return new PartitionBy(partitioner, supplier, supplier).apply(new ArrayIterator<T>(values));
    }

    public static <T, C extends Collection<T>> Pair<C, C> partition(T[] values, Predicate<T> partitioner, Supplier<C> collectionsProvider) {
        return new PartitionBy<T, C, C>(partitioner, collectionsProvider, collectionsProvider).apply(new ArrayIterator<T>(values));
    }

    public static <T, CA extends Collection<T>, CR extends Collection<T>> Pair<CA, CR> partition(T[] values, Predicate<T> partitioner, Supplier<CA> acceptedCollectionProvider, Supplier<CR> refusedCollectionProvider) {
        return new PartitionBy<T, CA, CR>(partitioner, acceptedCollectionProvider, refusedCollectionProvider).apply(new ArrayIterator<T>(values));
    }

    public static <K, V, M extends Map<K, V>> Map<K, V> indexBy(Iterable<V> groupies, Function<V, K> indexer, Supplier<M> mapProvider) {
        dbc.precondition(groupies != null, "cannot index from a null iterable", new Object[0]);
        return new IndexBy<M, K, V>(indexer, mapProvider).apply(groupies.iterator());
    }

    public static <K, V> Map<K, V> indexBy(Iterable<V> groupies, Function<V, K> indexer) {
        dbc.precondition(groupies != null, "cannot index from a null iterable", new Object[0]);
        return new IndexBy(indexer, new HashMapFactory()).apply(groupies.iterator());
    }

    public static <K, V, M extends Map<K, V>> Map<K, V> indexBy(Iterator<V> groupies, Function<V, K> indexer, Supplier<M> mapProvider) {
        return new IndexBy<M, K, V>(indexer, mapProvider).apply(groupies);
    }

    public static <K, V> Map<K, V> indexBy(Iterator<V> groupies, Function<V, K> indexer) {
        return new IndexBy(indexer, new HashMapFactory()).apply(groupies);
    }

    public static <K, V, M extends Map<K, V>> Map<K, V> indexBy(V[] groupies, Function<V, K> indexer, Supplier<M> mapProvider) {
        return new IndexBy<M, K, V>(indexer, mapProvider).apply((Iterator<V>)new ArrayIterator<V>(groupies));
    }

    public static <K, V> Map<K, V> indexBy(V[] groupies, Function<V, K> indexer) {
        return new IndexBy(indexer, new HashMapFactory()).apply((Iterator<V>)new ArrayIterator<V>(groupies));
    }
}

