/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional;

import java.util.Iterator;
import java.util.function.Predicate;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.filtering.AtMostMemoryIterator;
import net.emaze.dysfunctional.filtering.DropWhile;
import net.emaze.dysfunctional.filtering.FilteringIterator;
import net.emaze.dysfunctional.filtering.MemoryIterator;
import net.emaze.dysfunctional.filtering.TakeUpToIterator;
import net.emaze.dysfunctional.filtering.TakeWhileIterator;
import net.emaze.dysfunctional.filtering.UntilCount;
import net.emaze.dysfunctional.iterations.ArrayIterator;

public abstract class Filtering {
    public static <E> Iterator<E> filter(Iterator<E> iterator, Predicate<E> predicate) {
        return new FilteringIterator<E>(iterator, predicate);
    }

    public static <E> Iterator<E> filter(Iterable<E> iterable, Predicate<E> predicate) {
        dbc.precondition(iterable != null, "cannot call filter with a null iterable", new Object[0]);
        return Filtering.filter(iterable.iterator(), predicate);
    }

    public static <E> Iterator<E> filter(E[] array, Predicate<E> predicate) {
        return Filtering.filter(new ArrayIterator<E>(array), predicate);
    }

    public static <E> Iterator<E> takeLast(int howMany, Iterable<E> from) {
        dbc.precondition(from != null, "cannot call last with a null iterable", new Object[0]);
        return Filtering.takeLast(howMany, from.iterator());
    }

    public static <E> Iterator<E> takeLast(int howMany, Iterator<E> from) {
        return new MemoryIterator<E>(from, howMany);
    }

    public static <E> Iterator<E> takeLast(int howMany, E[] from) {
        return Filtering.takeLast(howMany, new ArrayIterator<E>(from));
    }

    public static <E> Iterator<E> atMostLast(int howMany, Iterable<E> from) {
        dbc.precondition(from != null, "cannot call atMostLast with a null iterable", new Object[0]);
        return Filtering.atMostLast(howMany, from.iterator());
    }

    public static <E> Iterator<E> atMostLast(int howMany, Iterator<E> from) {
        return new AtMostMemoryIterator<E>(from, howMany);
    }

    public static <E> Iterator<E> atMostLast(int howMany, E[] from) {
        return Filtering.atMostLast(howMany, new ArrayIterator<E>(from));
    }

    public static <E> Iterator<E> takeWhile(Iterator<E> iterator, Predicate<E> predicate) {
        return new TakeWhileIterator<E>(iterator, predicate);
    }

    public static <E> Iterator<E> takeWhile(Iterable<E> iterable, Predicate<E> predicate) {
        dbc.precondition(iterable != null, "cannot takeWhile from a null iterable", new Object[0]);
        return new TakeWhileIterator<E>(iterable.iterator(), predicate);
    }

    public static <E> Iterator<E> takeWhile(E[] array, Predicate<E> predicate) {
        return new TakeWhileIterator<E>(new ArrayIterator<E>(array), predicate);
    }

    public static <E> Iterator<E> dropWhile(Iterator<E> iterator, Predicate<E> predicate) {
        return new FilteringIterator<E>(iterator, new DropWhile<E>(predicate));
    }

    public static <E> Iterator<E> dropWhile(Iterable<E> iterable, Predicate<E> predicate) {
        dbc.precondition(iterable != null, "cannot dropWhile from a null iterable", new Object[0]);
        return new FilteringIterator<E>(iterable.iterator(), new DropWhile<E>(predicate));
    }

    public static <E> Iterator<E> dropWhile(E[] array, Predicate<E> predicate) {
        return new FilteringIterator<E>(new ArrayIterator<E>(array), new DropWhile<E>(predicate));
    }

    public static <E> Iterator<E> take(long howMany, Iterator<E> iterator) {
        return new TakeUpToIterator<E>(iterator, howMany);
    }

    public static <E> Iterator<E> take(long howMany, Iterable<E> iterable) {
        dbc.precondition(iterable != null, "cannot take from a null iterable", new Object[0]);
        return new TakeUpToIterator<E>(iterable.iterator(), howMany);
    }

    public static <E> Iterator<E> take(long howMany, E ... array) {
        return new TakeUpToIterator<E>(new ArrayIterator<E>(array), howMany);
    }

    public static <E> Iterator<E> drop(long howMany, Iterator<E> iterator) {
        return new FilteringIterator<E>(iterator, new DropWhile(new UntilCount(howMany)));
    }

    public static <E> Iterator<E> drop(long howMany, Iterable<E> iterable) {
        dbc.precondition(iterable != null, "cannot drop from a null iterable", new Object[0]);
        return new FilteringIterator<E>(iterable.iterator(), new DropWhile(new UntilCount(howMany)));
    }

    public static <E> Iterator<E> drop(long howMany, E ... array) {
        return new FilteringIterator<E>(new ArrayIterator<E>(array), new DropWhile(new UntilCount(howMany)));
    }

    public static <E> Iterator<E> slice(long from, long howMany, Iterator<E> iterator) {
        FilteringIterator<E> dropping = new FilteringIterator<E>(iterator, new DropWhile(new UntilCount(from)));
        return new TakeUpToIterator<E>(dropping, howMany);
    }

    public static <E> Iterator<E> slice(long from, long howMany, Iterable<E> iterable) {
        dbc.precondition(iterable != null, "cannot call slice with a null iterable", new Object[0]);
        FilteringIterator<E> dropping = new FilteringIterator<E>(iterable.iterator(), new DropWhile(new UntilCount(from)));
        return new TakeUpToIterator<E>(dropping, howMany);
    }

    public static <E> Iterator<E> slice(long from, long howMany, E ... array) {
        FilteringIterator<E> dropping = new FilteringIterator<E>(ArrayIterator.of(array), new DropWhile(new UntilCount(from)));
        return new TakeUpToIterator<E>(dropping, howMany);
    }
}

