/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional;

import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.emaze.dysfunctional.collections.ArrayListFactory;
import net.emaze.dysfunctional.consumers.ConsumeIntoCollection;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.delegates.Tapper;
import net.emaze.dysfunctional.iterations.ArrayIterator;
import net.emaze.dysfunctional.iterations.TransformingIterator;

public abstract class Applications {
    public static <R, E> Iterator<R> transform(Iterable<E> iterable, Function<E, R> function) {
        dbc.precondition(iterable != null, "cannot call transform with a null iterable", new Object[0]);
        return new TransformingIterator<E, R>(iterable.iterator(), function);
    }

    public static <R, E> Iterator<R> transform(Iterator<E> iterator, Function<E, R> function) {
        return new TransformingIterator<E, R>(iterator, function);
    }

    public static <R, E> Iterator<R> transform(E[] array, Function<E, R> function) {
        return new TransformingIterator<E, R>(new ArrayIterator<E>(array), function);
    }

    public static <E> Iterator<E> tap(Iterator<E> iterator, Consumer<E> consumer) {
        return new TransformingIterator(iterator, new Tapper<E>(consumer));
    }

    public static <E> Iterator<E> tap(Iterable<E> iterable, Consumer<E> consumer) {
        dbc.precondition(iterable != null, "cannot tap on a null iterable", new Object[0]);
        return new TransformingIterator(iterable.iterator(), new Tapper<E>(consumer));
    }

    public static <E> Iterator<E> tap(E[] array, Consumer<E> consumer) {
        return new TransformingIterator(new ArrayIterator<E>(array), new Tapper<E>(consumer));
    }

    public static <E> void each(Iterable<E> iterable, Consumer<E> consumer) {
        dbc.precondition(iterable != null, "cannot call each with a null iterable", new Object[0]);
        dbc.precondition(consumer != null, "cannot call each with a null consumer", new Object[0]);
        for (E element : iterable) {
            consumer.accept(element);
        }
    }

    public static <E> void each(Iterator<E> iterator, Consumer<E> consumer) {
        dbc.precondition(iterator != null, "cannot call each with a null iterator", new Object[0]);
        dbc.precondition(consumer != null, "cannot call each with a null consumer", new Object[0]);
        while (iterator.hasNext()) {
            consumer.accept(iterator.next());
        }
    }

    public static <E> void each(E[] array, Consumer<E> consumer) {
        dbc.precondition(array != null, "cannot call each with a null array", new Object[0]);
        dbc.precondition(consumer != null, "cannot call each with a null consumer", new Object[0]);
        for (int i = 0; i != array.length; ++i) {
            consumer.accept(array[i]);
        }
    }

    public static <R, E> List<R> map(Iterable<E> iterable, Function<E, R> function) {
        dbc.precondition(iterable != null, "cannot map from a null iterable", new Object[0]);
        TransformingIterator<E, R> transformed = new TransformingIterator<E, R>(iterable.iterator(), function);
        ConsumeIntoCollection consumer = new ConsumeIntoCollection(new ArrayListFactory());
        return (List)consumer.apply(transformed);
    }

    public static <R, E> List<R> map(Iterator<E> iterator, Function<E, R> function) {
        TransformingIterator<E, R> transformed = new TransformingIterator<E, R>(iterator, function);
        ConsumeIntoCollection consumer = new ConsumeIntoCollection(new ArrayListFactory());
        return (List)consumer.apply(transformed);
    }

    public static <R, E> List<R> map(E[] array, Function<E, R> function) {
        TransformingIterator<E, R> transformed = new TransformingIterator<E, R>(new ArrayIterator<E>(array), function);
        ConsumeIntoCollection consumer = new ConsumeIntoCollection(new ArrayListFactory());
        return (List)consumer.apply(transformed);
    }
}

