/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.strings;

import java.util.NoSuchElementException;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.iterations.ReadOnlyIterator;

public class StringIterator
extends ReadOnlyIterator<Character> {
    private final String value;
    private int currentPosition;

    public StringIterator(String value) {
        dbc.precondition(value != null, "cannot create StringIterator with a null String", new Object[0]);
        this.value = value;
        this.currentPosition = 0;
    }

    @Override
    public boolean hasNext() {
        return !this.limitReached();
    }

    private boolean limitReached() {
        return this.currentPosition == this.value.length();
    }

    @Override
    public Character next() {
        if (this.limitReached()) {
            throw new NoSuchElementException("iterator is consumed");
        }
        return Character.valueOf(this.value.charAt(this.currentPosition++));
    }
}

