/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.order;

import java.io.Serializable;
import java.util.Comparator;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.order.Order;

public class StrictOrderingFloatComparator
implements Comparator<Float>,
Serializable {
    private static final long serialVersionUID = 1L;

    @Override
    public int compare(Float lhs, Float rhs) {
        int rhsBits;
        dbc.precondition(lhs != null, "null double (lhs) on StrictOrderingFloatComparator", new Object[0]);
        dbc.precondition(rhs != null, "null double (rhs) on StrictOrderingFloatComparator", new Object[0]);
        if (lhs.floatValue() < rhs.floatValue()) {
            return Order.LT.order();
        }
        if (lhs.floatValue() > rhs.floatValue()) {
            return Order.GT.order();
        }
        int lhsBits = Float.floatToIntBits(lhs.floatValue());
        if (lhsBits == (rhsBits = Float.floatToIntBits(rhs.floatValue()))) {
            return 0;
        }
        return lhsBits < rhsBits ? Order.LT.order() : Order.GT.order();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof StrictOrderingFloatComparator;
    }

    public int hashCode() {
        return StrictOrderingFloatComparator.class.hashCode();
    }
}

