/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.order;

import java.util.Comparator;
import net.emaze.dysfunctional.order.Order;
import net.emaze.dysfunctional.order.StrictOrderingDoubleComparator;
import net.emaze.dysfunctional.order.StrictOrderingFloatComparator;

public class CompareToBuilder {
    private Order comparison = Order.EQ;

    public CompareToBuilder appendSuper(int superCompareTo) {
        if (this.comparison != Order.EQ) {
            return this;
        }
        this.comparison = Order.of(superCompareTo);
        return this;
    }

    public CompareToBuilder append(Object lhs, Object rhs) {
        return this.append(lhs, rhs, null);
    }

    public CompareToBuilder append(Object lhs, Object rhs, Comparator comparator) {
        if (this.comparison != Order.EQ) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null) {
            this.comparison = Order.LT;
            return this;
        }
        if (rhs == null) {
            this.comparison = Order.GT;
            return this;
        }
        if (lhs.getClass().isArray()) {
            if (lhs instanceof long[]) {
                this.append((long[])lhs, (long[])rhs);
            } else if (lhs instanceof int[]) {
                this.append((int[])lhs, (int[])rhs);
            } else if (lhs instanceof short[]) {
                this.append((short[])lhs, (short[])rhs);
            } else if (lhs instanceof char[]) {
                this.append((char[])lhs, (char[])rhs);
            } else if (lhs instanceof byte[]) {
                this.append((byte[])lhs, (byte[])rhs);
            } else if (lhs instanceof double[]) {
                this.append((double[])lhs, (double[])rhs);
            } else if (lhs instanceof float[]) {
                this.append((float[])lhs, (float[])rhs);
            } else if (lhs instanceof boolean[]) {
                this.append((boolean[])lhs, (boolean[])rhs);
            } else {
                this.append((Object[])lhs, (Object[])rhs, comparator);
            }
        } else {
            this.comparison = comparator == null ? Order.of(((Comparable)lhs).compareTo(rhs)) : Order.of(comparator.compare(lhs, rhs));
        }
        return this;
    }

    public CompareToBuilder append(long lhs, long rhs) {
        if (this.comparison != Order.EQ) {
            return this;
        }
        this.comparison = Order.of(Long.valueOf(lhs).compareTo(rhs));
        return this;
    }

    public CompareToBuilder append(int lhs, int rhs) {
        if (this.comparison != Order.EQ) {
            return this;
        }
        this.comparison = Order.of(Integer.valueOf(lhs).compareTo(rhs));
        return this;
    }

    public CompareToBuilder append(short lhs, short rhs) {
        if (this.comparison != Order.EQ) {
            return this;
        }
        this.comparison = Order.of(Short.valueOf(lhs).compareTo(rhs));
        return this;
    }

    public CompareToBuilder append(char lhs, char rhs) {
        if (this.comparison != Order.EQ) {
            return this;
        }
        this.comparison = Order.of(Character.valueOf(lhs).compareTo(Character.valueOf(rhs)));
        return this;
    }

    public CompareToBuilder append(byte lhs, byte rhs) {
        if (this.comparison != Order.EQ) {
            return this;
        }
        this.comparison = Order.of(Byte.valueOf(lhs).compareTo(rhs));
        return this;
    }

    public CompareToBuilder append(double lhs, double rhs) {
        if (this.comparison != Order.EQ) {
            return this;
        }
        this.comparison = Order.of(new StrictOrderingDoubleComparator().compare(lhs, rhs));
        return this;
    }

    public CompareToBuilder append(float lhs, float rhs) {
        if (this.comparison != Order.EQ) {
            return this;
        }
        this.comparison = Order.of(new StrictOrderingFloatComparator().compare(Float.valueOf(lhs), Float.valueOf(rhs)));
        return this;
    }

    public CompareToBuilder append(boolean lhs, boolean rhs) {
        if (this.comparison != Order.EQ) {
            return this;
        }
        this.comparison = Order.of(Boolean.valueOf(lhs).compareTo(rhs));
        return this;
    }

    public CompareToBuilder append(Object[] lhs, Object[] rhs) {
        return this.append(lhs, rhs, (Comparator)null);
    }

    public CompareToBuilder append(Object[] lhs, Object[] rhs, Comparator comparator) {
        if (this.comparison != Order.EQ) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null) {
            this.comparison = Order.LT;
            return this;
        }
        if (rhs == null) {
            this.comparison = Order.GT;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.comparison = Order.of(Integer.valueOf(lhs.length).compareTo(rhs.length));
            return this;
        }
        for (int i = 0; i < lhs.length && this.comparison == Order.EQ; ++i) {
            this.append(lhs[i], rhs[i], comparator);
        }
        return this;
    }

    public CompareToBuilder append(long[] lhs, long[] rhs) {
        if (this.comparison != Order.EQ) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null) {
            this.comparison = Order.LT;
            return this;
        }
        if (rhs == null) {
            this.comparison = Order.GT;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.comparison = Order.of(Integer.valueOf(lhs.length).compareTo(rhs.length));
            return this;
        }
        for (int i = 0; i < lhs.length && this.comparison == Order.EQ; ++i) {
            this.append(lhs[i], rhs[i]);
        }
        return this;
    }

    public CompareToBuilder append(int[] lhs, int[] rhs) {
        if (this.comparison != Order.EQ) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null) {
            this.comparison = Order.LT;
            return this;
        }
        if (rhs == null) {
            this.comparison = Order.GT;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.comparison = Order.of(Integer.valueOf(lhs.length).compareTo(rhs.length));
            return this;
        }
        for (int i = 0; i < lhs.length && this.comparison == Order.EQ; ++i) {
            this.append(lhs[i], rhs[i]);
        }
        return this;
    }

    public CompareToBuilder append(short[] lhs, short[] rhs) {
        if (this.comparison != Order.EQ) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null) {
            this.comparison = Order.LT;
            return this;
        }
        if (rhs == null) {
            this.comparison = Order.GT;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.comparison = Order.of(Integer.valueOf(lhs.length).compareTo(rhs.length));
            return this;
        }
        for (int i = 0; i < lhs.length && this.comparison == Order.EQ; ++i) {
            this.append(lhs[i], rhs[i]);
        }
        return this;
    }

    public CompareToBuilder append(char[] lhs, char[] rhs) {
        if (this.comparison != Order.EQ) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null) {
            this.comparison = Order.LT;
            return this;
        }
        if (rhs == null) {
            this.comparison = Order.GT;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.comparison = Order.of(Integer.valueOf(lhs.length).compareTo(rhs.length));
            return this;
        }
        for (int i = 0; i < lhs.length && this.comparison == Order.EQ; ++i) {
            this.append(lhs[i], rhs[i]);
        }
        return this;
    }

    public CompareToBuilder append(byte[] lhs, byte[] rhs) {
        if (this.comparison != Order.EQ) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null) {
            this.comparison = Order.LT;
            return this;
        }
        if (rhs == null) {
            this.comparison = Order.GT;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.comparison = Order.of(Integer.valueOf(lhs.length).compareTo(rhs.length));
            return this;
        }
        for (int i = 0; i < lhs.length && this.comparison == Order.EQ; ++i) {
            this.append(lhs[i], rhs[i]);
        }
        return this;
    }

    public CompareToBuilder append(double[] lhs, double[] rhs) {
        if (this.comparison != Order.EQ) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null) {
            this.comparison = Order.LT;
            return this;
        }
        if (rhs == null) {
            this.comparison = Order.GT;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.comparison = Order.of(Integer.valueOf(lhs.length).compareTo(rhs.length));
            return this;
        }
        for (int i = 0; i < lhs.length && this.comparison == Order.EQ; ++i) {
            this.append(lhs[i], rhs[i]);
        }
        return this;
    }

    public CompareToBuilder append(float[] lhs, float[] rhs) {
        if (this.comparison != Order.EQ) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null) {
            this.comparison = Order.LT;
            return this;
        }
        if (rhs == null) {
            this.comparison = Order.GT;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.comparison = Order.of(Integer.valueOf(lhs.length).compareTo(rhs.length));
            return this;
        }
        for (int i = 0; i < lhs.length && this.comparison == Order.EQ; ++i) {
            this.append(lhs[i], rhs[i]);
        }
        return this;
    }

    public CompareToBuilder append(boolean[] lhs, boolean[] rhs) {
        if (this.comparison != Order.EQ) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null) {
            this.comparison = Order.LT;
            return this;
        }
        if (rhs == null) {
            this.comparison = Order.GT;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.comparison = Order.of(Integer.valueOf(lhs.length).compareTo(rhs.length));
            return this;
        }
        for (int i = 0; i < lhs.length && this.comparison == Order.EQ; ++i) {
            this.append(lhs[i], rhs[i]);
        }
        return this;
    }

    public int toComparison() {
        return this.comparison.order();
    }

    public Order toOrder() {
        return this.comparison;
    }
}

