/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.multiplexing;

import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.iterations.ReadOnlyIterator;

public class CyclicIterator<E>
extends ReadOnlyIterator<E> {
    private final Deque<E> memory = new LinkedList();
    private Iterator<E> source;

    public CyclicIterator(Iterator<E> source) {
        dbc.precondition(source != null, "source iterator cannot be null", new Object[0]);
        this.source = source;
    }

    @Override
    public boolean hasNext() {
        return this.source.hasNext() || !this.memory.isEmpty();
    }

    @Override
    public E next() {
        E value = this.source.hasNext() ? this.source.next() : this.memory.removeLast();
        this.memory.push(value);
        return value;
    }
}

