/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.interceptions;

import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.delegates.Delegate;
import net.emaze.dysfunctional.interceptions.Interceptor;

public class InterceptorAdapter<R, T>
implements Delegate<R, T> {
    private final Interceptor<T> interceptor;
    private final Delegate<R, T> inner;

    public InterceptorAdapter(Interceptor<T> interceptor, Delegate<R, T> inner) {
        dbc.precondition(interceptor != null, "cannot adapt a null interceptor", new Object[0]);
        dbc.precondition(inner != null, "cannot adapt with a null inner delegate", new Object[0]);
        this.interceptor = interceptor;
        this.inner = inner;
    }

    @Override
    public R perform(T value) {
        this.interceptor.before(value);
        try {
            R r = this.inner.perform(value);
            return r;
        }
        finally {
            this.interceptor.after(value);
        }
    }
}

