/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.dispatching.delegates;

import java.util.HashMap;
import java.util.Map;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.delegates.Delegate;

public class MemoizingDelegate<R, T>
implements Delegate<R, T> {
    private final Delegate<R, T> delegate;
    private final Map<T, R> cache;

    public MemoizingDelegate(Delegate<R, T> delegate) {
        this(delegate, new HashMap());
    }

    public MemoizingDelegate(Delegate<R, T> delegate, Map<T, R> cache) {
        dbc.precondition(delegate != null, "Cannot create a memoizing delegate with a null delegate", new Object[0]);
        dbc.precondition(cache != null, "Cannot create a memoizing delegate with a null cache", new Object[0]);
        this.delegate = delegate;
        this.cache = cache;
    }

    @Override
    public R perform(T t) {
        if (this.cache.containsKey(t)) {
            return this.cache.get(t);
        }
        R result = this.delegate.perform(t);
        this.cache.put(t, result);
        return result;
    }
}

