/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.dispatching.delegates;

import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.delegates.BinaryDelegate;
import net.emaze.dysfunctional.dispatching.delegates.Delegate;

public class BinaryComposer<R, T1, T2, T3>
implements BinaryDelegate<R, T2, T3> {
    private final BinaryDelegate<T1, T2, T3> binary;
    private final Delegate<R, T1> unary;

    public BinaryComposer(Delegate<R, T1> unary, BinaryDelegate<T1, T2, T3> binary) {
        dbc.precondition(unary != null, "cannot compose a null unary delegate", new Object[0]);
        dbc.precondition(binary != null, "cannot compose a null binary delegate", new Object[0]);
        this.unary = unary;
        this.binary = binary;
    }

    @Override
    public R perform(T2 first, T3 second) {
        return this.unary.perform(this.binary.perform(first, second));
    }
}

