/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional;

import java.util.Arrays;
import java.util.Iterator;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.iterations.ArrayIterator;
import net.emaze.dysfunctional.iterations.ConstantIterator;
import net.emaze.dysfunctional.strings.ConcatStrings;
import net.emaze.dysfunctional.strings.InterposeStrings;
import net.emaze.dysfunctional.strings.JoinStrings;

public abstract class Strings {
    public static String concat(String ... array) {
        return new ConcatStrings().perform((Iterator<String>)new ArrayIterator<String>(array));
    }

    public static String concat(Iterable<String> iterable) {
        dbc.precondition(iterable != null, "cannot concat a null iterable", new Object[0]);
        return new ConcatStrings().perform(iterable.iterator());
    }

    public static String concat(Iterator<String> iterator) {
        return new ConcatStrings().perform(iterator);
    }

    public static <T> String join(T[] array) {
        return new JoinStrings<T>().perform(new ArrayIterator<T>(array));
    }

    public static <T> String join(Iterable<T> iterable) {
        dbc.precondition(iterable != null, "cannot join a null iterable", new Object[0]);
        return new JoinStrings<T>().perform(iterable.iterator());
    }

    public static <T> String join(Iterator<T> iterator) {
        return new JoinStrings<T>().perform(iterator);
    }

    public static <T, V> String interpose(T[] values, Iterator<V> separators) {
        return new InterposeStrings<T, V>().perform(new ArrayIterator<T>(values), separators);
    }

    public static <T, V> String interpose(Iterable<T> values, Iterator<V> separators) {
        dbc.precondition(values != null, "calling interpose with a null iterable", new Object[0]);
        return new InterposeStrings<T, V>().perform(values.iterator(), separators);
    }

    public static <T, V> String interpose(Iterator<T> values, Iterator<V> separators) {
        return new InterposeStrings<T, V>().perform(values, separators);
    }

    public static <T, V> String interpose(T[] values, V separator) {
        return new InterposeStrings<T, V>().perform(new ArrayIterator<T>(values), (Iterator<V>)new ConstantIterator<V>(separator));
    }

    public static <T, V> String interpose(Iterable<T> values, V separator) {
        dbc.precondition(values != null, "cannot interpose from a null iterable", new Object[0]);
        return new InterposeStrings<T, V>().perform(values.iterator(), (Iterator<V>)new ConstantIterator<V>(separator));
    }

    public static <T, V> String interpose(Iterator<T> values, V separator) {
        return new InterposeStrings<T, V>().perform(values, (Iterator<V>)new ConstantIterator<V>(separator));
    }

    public static String repeat(char source, int times) {
        dbc.precondition(times > -1, "times must be non negative", new Object[0]);
        char[] array = new char[times];
        Arrays.fill(array, source);
        return new String(array);
    }

    public static String repeat(String source, int times) {
        dbc.precondition(source != null, "cannot repeat a null source", new Object[0]);
        dbc.precondition(times > -1, "times must be non negative", new Object[0]);
        int srcLen = source.length();
        long longLen = (long)times * (long)srcLen;
        int len = (int)longLen;
        dbc.precondition(longLen == (long)len, "resulting String would be too long", new Object[0]);
        char[] array = new char[len];
        for (int i = 0; i != times; ++i) {
            source.getChars(0, srcLen, array, i * srcLen);
        }
        return new String(array);
    }
}

