/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.tuples;

import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.delegates.Delegate;
import net.emaze.dysfunctional.equality.EqualsBuilder;
import net.emaze.dysfunctional.hashing.HashCodeBuilder;

public class Triple<T1, T2, T3> {
    private final T1 f;
    private final T2 s;
    private final T3 t;

    public Triple(T1 first, T2 second, T3 third) {
        this.f = first;
        this.s = second;
        this.t = third;
    }

    public T1 first() {
        return this.f;
    }

    public T2 second() {
        return this.s;
    }

    public T3 third() {
        return this.t;
    }

    public <R1, R2, R3> Triple<R1, R2, R3> fmap(Delegate<R1, T1> withFirst, Delegate<R2, T2> withSecond, Delegate<R3, T3> withThird) {
        dbc.precondition(withFirst != null, "cannot fmap on triple with a null first delegate", new Object[0]);
        dbc.precondition(withSecond != null, "cannot fmap on triple with a null second delegate", new Object[0]);
        dbc.precondition(withThird != null, "cannot fmap on triple with a null second delegate", new Object[0]);
        return Triple.of(withFirst.perform(this.f), withSecond.perform(this.s), withThird.perform(this.t));
    }

    public boolean equals(Object rhs) {
        if (!(rhs instanceof Triple)) {
            return false;
        }
        Triple other = (Triple)rhs;
        return new EqualsBuilder().append(this.f, other.f).append(this.s, other.s).append(this.t, other.t).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.f).append(this.s).append(this.t).toHashCode();
    }

    public String toString() {
        return String.format("(%s,%s,%s)", this.f, this.s, this.t);
    }

    public static <T1, T2, T3> Triple<T1, T2, T3> of(T1 first, T2 second, T3 third) {
        return new Triple<T1, T2, T3>(first, second, third);
    }
}

