/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.tuples;

import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.delegates.Delegate;
import net.emaze.dysfunctional.tuples.Triple;

public class FmapTriple<R1, R2, R3, T1, T2, T3>
implements Delegate<Triple<R1, R2, R3>, Triple<T1, T2, T3>> {
    private final Delegate<R1, T1> first;
    private final Delegate<R2, T2> second;
    private final Delegate<R3, T3> third;

    public FmapTriple(Delegate<R1, T1> first, Delegate<R2, T2> second, Delegate<R3, T3> third) {
        dbc.precondition(first != null, "cannot create FmapTriple with a null first delegate", new Object[0]);
        dbc.precondition(second != null, "cannot create FmapTriple with a null second delegate", new Object[0]);
        dbc.precondition(third != null, "cannot create FmapTriple with a null third delegate", new Object[0]);
        this.first = first;
        this.second = second;
        this.third = third;
    }

    @Override
    public Triple<R1, R2, R3> perform(Triple<T1, T2, T3> from) {
        dbc.precondition(from != null, "cannot fmap a null triple", new Object[0]);
        return from.fmap(this.first, this.second, this.third);
    }
}

