/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.order;

import java.io.Serializable;
import java.util.Comparator;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.order.Order;

public class StrictOrderingDoubleComparator
implements Comparator<Double>,
Serializable {
    private static final long serialVersionUID = 1L;

    @Override
    public int compare(Double lhs, Double rhs) {
        long rhsBits;
        dbc.precondition(lhs != null, "null double (lhs) on StrictOrderingDoubleComparator", new Object[0]);
        dbc.precondition(rhs != null, "null double (rhs) on StrictOrderingDoubleComparator", new Object[0]);
        if (lhs < rhs) {
            return Order.LT.order();
        }
        if (lhs > rhs) {
            return Order.GT.order();
        }
        long lhsBits = Double.doubleToLongBits(lhs);
        if (lhsBits == (rhsBits = Double.doubleToLongBits(rhs))) {
            return 0;
        }
        return lhsBits < rhsBits ? Order.LT.order() : Order.GT.order();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof StrictOrderingDoubleComparator;
    }

    public int hashCode() {
        return StrictOrderingDoubleComparator.class.hashCode();
    }
}

