/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.options;

import java.util.Iterator;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.iterations.ReadOnlyIterator;
import net.emaze.dysfunctional.options.Maybe;

public class MaybeIterator<E>
extends ReadOnlyIterator<Maybe<E>> {
    private final Iterator<E> iterator;

    public MaybeIterator(Iterator<E> iterator) {
        dbc.precondition(iterator != null, "trying to create a MaybeIterator from a null iterator", new Object[0]);
        this.iterator = iterator;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public Maybe<E> next() {
        if (this.iterator.hasNext()) {
            return Maybe.just(this.iterator.next());
        }
        return Maybe.nothing();
    }
}

