/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.multiplexing;

import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.iterations.ReadOnlyIterator;
import net.emaze.dysfunctional.options.Box;

public class RoundrobinIterator<E>
extends ReadOnlyIterator<E> {
    private final Iterator<? extends Iterator<E>> iterators;
    private final Deque<Iterator<E>> memory = new LinkedList<Iterator<E>>();
    private final Box<Iterator<E>> prefetched = Box.empty();

    public <T extends Iterator<E>> RoundrobinIterator(Iterator<T> iterators) {
        dbc.precondition(iterators != null, "trying to create a RoundRobinIterator from a null iterator of iterators", new Object[0]);
        this.iterators = iterators;
    }

    @Override
    public boolean hasNext() {
        this.prefetchedAndMemorizeNonEmpty();
        return this.prefetched.hasContent();
    }

    @Override
    public E next() {
        this.prefetchedAndMemorizeNonEmpty();
        if (!this.prefetched.hasContent()) {
            throw new NoSuchElementException();
        }
        return this.prefetched.unload().value().next();
    }

    private void prefetchedAndMemorizeNonEmpty() {
        Iterator<E> candidate;
        if (this.prefetched.hasContent()) {
            return;
        }
        while (this.iterators.hasNext()) {
            candidate = this.iterators.next();
            if (!candidate.hasNext()) continue;
            this.prefetched.setContent(candidate);
            this.memory.push(candidate);
            return;
        }
        while (!this.memory.isEmpty()) {
            candidate = this.memory.removeLast();
            if (!candidate.hasNext()) continue;
            this.prefetched.setContent(candidate);
            this.memory.push(candidate);
            return;
        }
    }
}

