/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.iterations;

import java.util.NoSuchElementException;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.delegates.Delegate;
import net.emaze.dysfunctional.iterations.ReadOnlyIterator;
import net.emaze.dysfunctional.options.Box;
import net.emaze.dysfunctional.options.Maybe;

public class IteratorGenerator<T>
extends ReadOnlyIterator<T> {
    private final Delegate<Maybe<T>, T> generator;
    private final Box<T> next;
    private T current;
    private boolean active = true;

    public IteratorGenerator(T seed, Delegate<Maybe<T>, T> generator) {
        dbc.precondition(generator != null, "generator cannot be null", new Object[0]);
        this.generator = generator;
        this.next = Box.of(seed);
        this.current = seed;
    }

    @Override
    public boolean hasNext() {
        return this.fetchNext();
    }

    @Override
    public T next() {
        if (!this.fetchNext()) {
            throw new NoSuchElementException("generation has been completed");
        }
        return this.next.unload().value();
    }

    private boolean fetchNext() {
        if (this.active && this.next.isEmpty()) {
            Maybe<T> got = this.generator.perform(this.current);
            this.active = got.hasValue();
            if (this.active) {
                this.current = got.value();
                this.next.setContent(this.current);
            }
        }
        return this.active;
    }
}

