/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.iterations;

import java.util.NoSuchElementException;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.iterations.ReadOnlyIterator;

public class ArrayIterator<T>
extends ReadOnlyIterator<T> {
    private final T[] values;
    private int currentIndex = 0;

    public ArrayIterator(T[] values) {
        dbc.precondition(values != null, "trying to create an ArrayIterator<T> from a null array", new Object[0]);
        this.values = values;
    }

    public static <T> ArrayIterator<T> of(T ... elements) {
        return new ArrayIterator<T>(elements);
    }

    @Override
    public boolean hasNext() {
        return !this.isOutOfBounds();
    }

    private boolean isOutOfBounds() {
        return this.currentIndex == this.values.length;
    }

    @Override
    public T next() {
        if (this.isOutOfBounds()) {
            throw new NoSuchElementException("iterator is consumed");
        }
        T element = this.values[this.currentIndex];
        ++this.currentIndex;
        return element;
    }
}

