/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.convolutions;

import java.util.Iterator;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.iterations.ReadOnlyIterator;
import net.emaze.dysfunctional.options.Maybe;
import net.emaze.dysfunctional.options.MaybeIterator;
import net.emaze.dysfunctional.tuples.Pair;

public class ZipLongestIterator<E1, E2>
extends ReadOnlyIterator<Pair<Maybe<E1>, Maybe<E2>>> {
    private final MaybeIterator<E1> former;
    private final MaybeIterator<E2> latter;

    public ZipLongestIterator(Iterator<E1> former, Iterator<E2> latter) {
        dbc.precondition(former != null, "trying to create a ZipLongestIterator from a null iterator (former)", new Object[0]);
        dbc.precondition(latter != null, "trying to create a ZipLongestIterator from a null iterator (latter)", new Object[0]);
        this.former = new MaybeIterator<E1>(former);
        this.latter = new MaybeIterator<E2>(latter);
    }

    @Override
    public boolean hasNext() {
        return this.former.hasNext() || this.latter.hasNext();
    }

    @Override
    public Pair<Maybe<E1>, Maybe<E2>> next() {
        return Pair.of(this.former.next(), this.latter.next());
    }
}

