/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.emaze.dysfunctional.Compositions;
import net.emaze.dysfunctional.Iterations;
import net.emaze.dysfunctional.casts.Vary;
import net.emaze.dysfunctional.collections.ArrayListFactory;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.delegates.ConstantProvider;
import net.emaze.dysfunctional.dispatching.delegates.IteratorPlucker;
import net.emaze.dysfunctional.dispatching.delegates.Provider;
import net.emaze.dysfunctional.iterations.ArrayIterator;
import net.emaze.dysfunctional.iterations.TransformingIterator;
import net.emaze.dysfunctional.multiplexing.BatchingIterator;
import net.emaze.dysfunctional.multiplexing.ChainIterator;
import net.emaze.dysfunctional.multiplexing.CyclicIterator;
import net.emaze.dysfunctional.multiplexing.RoundrobinIterator;
import net.emaze.dysfunctional.multiplexing.RoundrobinLongestIterator;
import net.emaze.dysfunctional.multiplexing.RoundrobinShortestIterator;
import net.emaze.dysfunctional.multiplexing.UnchainIterator;
import net.emaze.dysfunctional.multiplexing.UnchainWithExactChannelSizeIterator;
import net.emaze.dysfunctional.options.Maybe;

public abstract class Multiplexing {
    public static <E, I extends Iterable<E>> Iterator<E> flatten(Iterator<I> iterables) {
        return new ChainIterator(new TransformingIterator(iterables, new IteratorPlucker()));
    }

    public static <E, I extends Iterable<E>> Iterator<E> flatten(Iterable<I> iterables) {
        dbc.precondition(iterables != null, "cannot flatten a null iterable", new Object[0]);
        Iterator<I> iterator = iterables.iterator();
        return new ChainIterator(new TransformingIterator(iterator, new IteratorPlucker()));
    }

    public static <E, I extends Iterable<E>> Iterator<E> flatten(I first, I second) {
        ArrayIterator<Iterable> iterator = ArrayIterator.of(first, second);
        return new ChainIterator(new TransformingIterator(iterator, new IteratorPlucker()));
    }

    public static <E, I extends Iterable<E>> Iterator<E> flatten(I first, I second, I third) {
        ArrayIterator<Iterable> iterator = ArrayIterator.of(first, second, third);
        return new ChainIterator(new TransformingIterator(iterator, new IteratorPlucker()));
    }

    public static <E, I extends Iterator<E>> Iterator<E> chain(Iterator<I> iterators) {
        return new ChainIterator(iterators);
    }

    public static <E, I extends Iterator<E>> Iterator<E> chain(Iterable<I> iterable) {
        dbc.precondition(iterable != null, "cannot chain a null iterable", new Object[0]);
        return new ChainIterator(iterable.iterator());
    }

    public static <E, I extends Iterator<E>> Iterator<E> chain(I first, I second) {
        return new ChainIterator(ArrayIterator.of(first, second));
    }

    public static <E, I extends Iterator<E>> Iterator<E> chain(I first, I second, I third) {
        return new ChainIterator(ArrayIterator.of(first, second, third));
    }

    public static <C extends Collection<E>, E> Iterator<C> batch(int batchSize, Iterator<E> iterator, Provider<C> channelProvider) {
        return new BatchingIterator<C, E>(batchSize, iterator, channelProvider);
    }

    public static <E> Iterator<List<E>> batch(int batchSize, Iterator<E> iterator) {
        Provider channelFactory = Compositions.compose(new Vary(), new ArrayListFactory());
        return new BatchingIterator(batchSize, iterator, channelFactory);
    }

    public static <C extends Collection<E>, E> Iterator<C> batch(int batchSize, Iterable<E> iterable, Provider<C> channelProvider) {
        dbc.precondition(iterable != null, "cannot batch a null iterable", new Object[0]);
        return new BatchingIterator<C, E>(batchSize, iterable.iterator(), channelProvider);
    }

    public static <E> Iterator<List<E>> batch(int batchSize, Iterable<E> iterable) {
        dbc.precondition(iterable != null, "cannot batch a null iterable", new Object[0]);
        Provider channelFactory = Compositions.compose(new Vary(), new ArrayListFactory());
        return new BatchingIterator(batchSize, iterable.iterator(), channelFactory);
    }

    public static <C extends Collection<E>, E> Iterator<C> batch(int batchSize, E[] array, Provider<C> channelProvider) {
        return new BatchingIterator<C, E>(batchSize, new ArrayIterator<E>(array), channelProvider);
    }

    public static <E> Iterator<List<E>> batch(int batchSize, E[] array) {
        Provider channelFactory = Compositions.compose(new Vary(), new ArrayListFactory());
        return new BatchingIterator(batchSize, new ArrayIterator<E>(array), channelFactory);
    }

    public static <E, I extends Iterator<E>> Iterator<E> roundrobin(Iterator<I> iterators) {
        return new RoundrobinIterator(iterators);
    }

    public static <E, I extends Iterator<E>> Iterator<E> roundrobin(Iterable<I> iterable) {
        dbc.precondition(iterable != null, "cannot roundrobin a null iterable", new Object[0]);
        return new RoundrobinIterator(iterable.iterator());
    }

    public static <E> Iterator<E> roundrobin(Iterator<E> first, Iterator<E> second) {
        return new RoundrobinIterator(ArrayIterator.of(first, second));
    }

    public static <E> Iterator<E> roundrobin(Iterator<E> first, Iterator<E> second, Iterator<E> third) {
        return new RoundrobinIterator(ArrayIterator.of(first, second, third));
    }

    public static <E, I extends Iterator<E>> Iterator<E> roundrobinShortest(Iterator<I> iterators) {
        return new RoundrobinShortestIterator(iterators);
    }

    public static <E, I extends Iterator<E>> Iterator<E> roundrobinShortest(Iterable<I> iterable) {
        dbc.precondition(iterable != null, "cannot roundrobinShortest a null iterable", new Object[0]);
        Iterator<I> iterator = iterable.iterator();
        return new RoundrobinShortestIterator(iterator);
    }

    public static <E> Iterator<E> roundrobinShortest(Iterator<E> first, Iterator<E> second) {
        ArrayIterator<Iterator> iterator = ArrayIterator.of(first, second);
        return new RoundrobinShortestIterator(iterator);
    }

    public static <E> Iterator<E> roundrobinShortest(Iterator<E> first, Iterator<E> second, Iterator<E> third) {
        ArrayIterator<Iterator> iterator = ArrayIterator.of(first, second, third);
        return new RoundrobinShortestIterator(iterator);
    }

    public static <E, I extends Iterator<E>> Iterator<Maybe<E>> roundrobinLongest(Iterator<I> iterators) {
        return new RoundrobinLongestIterator(iterators);
    }

    public static <E, I extends Iterator<E>> Iterator<Maybe<E>> roundrobinLongest(Iterable<I> iterable) {
        dbc.precondition(iterable != null, "cannot roundrobinLongest a null iterable", new Object[0]);
        Iterator<I> iterator = iterable.iterator();
        return new RoundrobinLongestIterator(iterator);
    }

    public static <E> Iterator<Maybe<E>> roundrobinLongest(Iterator<E> first, Iterator<E> second) {
        ArrayIterator<Iterator> iterator = ArrayIterator.of(first, second);
        return new RoundrobinLongestIterator(iterator);
    }

    public static <E> Iterator<Maybe<E>> roundrobinLongest(Iterator<E> first, Iterator<E> second, Iterator<E> third) {
        ArrayIterator<Iterator> iterator = ArrayIterator.of(first, second, third);
        return new RoundrobinLongestIterator(iterator);
    }

    public static <E> Iterator<E> cycle(Iterator<E> iterator) {
        return new CyclicIterator<E>(iterator);
    }

    public static <E> Iterator<E> cycle(Iterable<E> iterable) {
        dbc.precondition(iterable != null, "cannot cycle a null iterable", new Object[0]);
        return new CyclicIterator<E>(iterable.iterator());
    }

    public static <E> Iterator<E> cycle(E first, E second) {
        return new CyclicIterator<E>(Iterations.iterator(first, second));
    }

    public static <E> Iterator<E> cycle(E first, E second, E third) {
        return new CyclicIterator<E>(Iterations.iterator(first, second, third));
    }

    public static <C extends Collection<E>, E> Iterator<C> unchain(int channelSize, Iterator<E> iterator, Provider<C> channelProvider) {
        ConstantProvider<Maybe<Integer>> channelsSizesProvider = new ConstantProvider<Maybe<Integer>>(Maybe.just(channelSize));
        return new UnchainIterator<C, E>(channelsSizesProvider, iterator, channelProvider);
    }

    public static <E> Iterator<List<E>> unchain(int channelSize, Iterator<E> iterator) {
        ConstantProvider<Maybe<Integer>> channelsSizesProvider = new ConstantProvider<Maybe<Integer>>(Maybe.just(channelSize));
        Provider channelFactory = Compositions.compose(new Vary(), new ArrayListFactory());
        return new UnchainIterator(channelsSizesProvider, iterator, channelFactory);
    }

    public static <C extends Collection<E>, E> Iterator<C> unchain(int channelSize, Iterable<E> iterable, Provider<C> channelProvider) {
        dbc.precondition(iterable != null, "cannot unchain a null iterable", new Object[0]);
        ConstantProvider<Maybe<Integer>> channelsSizesProvider = new ConstantProvider<Maybe<Integer>>(Maybe.just(channelSize));
        Iterator<E> iterator = iterable.iterator();
        return new UnchainIterator<C, E>(channelsSizesProvider, iterator, channelProvider);
    }

    public static <E> Iterator<List<E>> unchain(int channelSize, Iterable<E> iterable) {
        dbc.precondition(iterable != null, "cannot unchain a null iterable", new Object[0]);
        ConstantProvider<Maybe<Integer>> channelsSizesProvider = new ConstantProvider<Maybe<Integer>>(Maybe.just(channelSize));
        Provider channelFactory = Compositions.compose(new Vary(), new ArrayListFactory());
        Iterator<E> iterator = iterable.iterator();
        return new UnchainIterator(channelsSizesProvider, iterator, channelFactory);
    }

    public static <C extends Collection<E>, E> Iterator<C> unchain(int channelSize, Provider<C> channelProvider, E ... array) {
        ConstantProvider<Maybe<Integer>> channelsSizesProvider = new ConstantProvider<Maybe<Integer>>(Maybe.just(channelSize));
        ArrayIterator<E> iterator = new ArrayIterator<E>(array);
        return new UnchainIterator<C, E>(channelsSizesProvider, iterator, channelProvider);
    }

    public static <E> Iterator<List<E>> unchain(int channelSize, E ... array) {
        ConstantProvider<Maybe<Integer>> channelsSizesProvider = new ConstantProvider<Maybe<Integer>>(Maybe.just(channelSize));
        Provider channelFactory = Compositions.compose(new Vary(), new ArrayListFactory());
        ArrayIterator<E> iterator = new ArrayIterator<E>(array);
        return new UnchainIterator(channelsSizesProvider, iterator, channelFactory);
    }

    public static <C extends Collection<Maybe<E>>, E> Iterator<C> unchainWithExactChannelSize(int channelSize, Iterator<E> iterator, Provider<C> channelProvider) {
        ConstantProvider<Maybe<Integer>> channelsSizesProvider = new ConstantProvider<Maybe<Integer>>(Maybe.just(channelSize));
        return new UnchainWithExactChannelSizeIterator<C, E>(channelsSizesProvider, iterator, channelProvider);
    }

    public static <E> Iterator<List<Maybe<E>>> unchainWithExactChannelSize(int channelSize, Iterator<E> iterator) {
        ConstantProvider<Maybe<Integer>> channelsSizesProvider = new ConstantProvider<Maybe<Integer>>(Maybe.just(channelSize));
        Provider channelFactory = Compositions.compose(new Vary(), new ArrayListFactory());
        return new UnchainWithExactChannelSizeIterator(channelsSizesProvider, iterator, channelFactory);
    }

    public static <C extends Collection<Maybe<E>>, E> Iterator<C> unchainWithExactChannelSize(int channelSize, Iterable<E> iterable, Provider<C> channelProvider) {
        dbc.precondition(iterable != null, "cannot unchainWithExactChannelSize a null iterable", new Object[0]);
        ConstantProvider<Maybe<Integer>> channelsSizesProvider = new ConstantProvider<Maybe<Integer>>(Maybe.just(channelSize));
        return new UnchainWithExactChannelSizeIterator<C, E>(channelsSizesProvider, iterable.iterator(), channelProvider);
    }

    public static <E> Iterator<List<Maybe<E>>> unchainWithExactChannelSize(int channelSize, Iterable<E> iterable) {
        dbc.precondition(iterable != null, "cannot unchainWithExactChannelSize a null iterable", new Object[0]);
        ConstantProvider<Maybe<Integer>> channelsSizesProvider = new ConstantProvider<Maybe<Integer>>(Maybe.just(channelSize));
        Provider channelFactory = Compositions.compose(new Vary(), new ArrayListFactory());
        return new UnchainWithExactChannelSizeIterator(channelsSizesProvider, iterable.iterator(), channelFactory);
    }

    public static <C extends Collection<Maybe<E>>, E> Iterator<C> unchainWithExactChannelSize(int channelSize, Provider<C> channelProvider, E ... array) {
        ConstantProvider<Maybe<Integer>> channelsSizesProvider = new ConstantProvider<Maybe<Integer>>(Maybe.just(channelSize));
        return new UnchainWithExactChannelSizeIterator<C, E>(channelsSizesProvider, new ArrayIterator<E>(array), channelProvider);
    }

    public static <E> Iterator<List<Maybe<E>>> unchainWithExactChannelSize(int channelSize, E ... array) {
        ConstantProvider<Maybe<Integer>> channelsSizesProvider = new ConstantProvider<Maybe<Integer>>(Maybe.just(channelSize));
        Provider channelFactory = Compositions.compose(new Vary(), new ArrayListFactory());
        return new UnchainWithExactChannelSizeIterator(channelsSizesProvider, new ArrayIterator<E>(array), channelFactory);
    }
}

