/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.ranges;

import java.util.Comparator;
import java.util.Iterator;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.options.Maybe;
import net.emaze.dysfunctional.order.Order;
import net.emaze.dysfunctional.order.SequencingPolicy;

public class RangeIterator<T>
implements Iterator<T> {
    private final SequencingPolicy<T> policy;
    private T current;
    private final Maybe<T> end;
    private Comparator<Maybe<T>> comparator;

    public RangeIterator(SequencingPolicy<T> policy, Comparator<Maybe<T>> comparator, T begin, Maybe<T> end) {
        dbc.precondition(policy != null, "trying to create a RangeIterator from a null policy", new Object[0]);
        dbc.precondition(comparator != null, "trying to create a RangeIterator from a null comparator", new Object[0]);
        dbc.precondition(begin != null, "trying to create a RangeIterator from a null start", new Object[0]);
        dbc.precondition(end != null, "trying to create a RangeIterator from a null upTo", new Object[0]);
        this.policy = policy;
        this.current = begin;
        this.end = end;
        this.comparator = comparator;
    }

    @Override
    public boolean hasNext() {
        return Order.of(this.comparator, Maybe.just(this.current), this.end).isLt();
    }

    @Override
    public T next() {
        T oldCurrent = this.current;
        this.current = this.policy.next(this.current).value();
        return oldCurrent;
    }

    @Override
    public void remove() {
    }
}

