/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.multiplexing;

import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.iterations.ReadOnlyIterator;
import net.emaze.dysfunctional.options.Box;
import net.emaze.dysfunctional.options.Maybe;

public class RoundrobinLongestIterator<E>
extends ReadOnlyIterator<Maybe<E>> {
    private final Iterator<? extends Iterator<E>> iterators;
    private final Deque<Iterator<E>> memory = new LinkedList<Iterator<E>>();
    private final Box<Iterator<E>> prefetched = Box.empty();
    private int fetchedCounter;

    public <T extends Iterator<E>> RoundrobinLongestIterator(Iterator<T> iterators) {
        dbc.precondition(iterators != null, "trying to create a RoundRobinLongestIterator from a null iterator of iterators", new Object[0]);
        this.iterators = iterators;
    }

    @Override
    public boolean hasNext() {
        this.prefetchAndMemorize();
        return !this.empty();
    }

    private boolean empty() {
        return !this.prefetched.hasContent() || !this.prefetched.getContent().hasNext() && this.fetchedCounter % this.memory.size() == 0;
    }

    @Override
    public Maybe<E> next() {
        this.prefetchAndMemorize();
        if (this.empty()) {
            throw new NoSuchElementException();
        }
        ++this.fetchedCounter;
        Iterator<E> current = this.prefetched.unload().value();
        return current.hasNext() ? Maybe.just(current.next()) : Maybe.nothing();
    }

    private void prefetchAndMemorize() {
        if (this.prefetched.hasContent()) {
            return;
        }
        if (this.iterators.hasNext()) {
            Iterator<E> iterator = this.iterators.next();
            this.prefetched.setContent(iterator);
            this.memory.push(iterator);
            return;
        }
        if (this.memory.isEmpty()) {
            return;
        }
        this.fetchedCounter %= this.memory.size();
        Iterator<E> iter = this.memory.removeLast();
        this.prefetched.setContent(iter);
        this.memory.push(iter);
    }
}

