/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.multiplexing;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.iterations.ReadOnlyIterator;

public class ChainIterator<E>
extends ReadOnlyIterator<E> {
    private final Iterator<? extends Iterator<E>> iterators;
    private Iterator<E> current;

    public <T extends Iterator<E>> ChainIterator(Iterator<T> iterators) {
        dbc.precondition(iterators != null, "trying to create a ChainIterator from a null iterator of iterators", new Object[0]);
        this.iterators = iterators;
    }

    @Override
    public boolean hasNext() {
        while ((this.current == null || !this.current.hasNext()) && this.iterators.hasNext()) {
            this.current = this.iterators.next();
        }
        return this.current != null && this.current.hasNext();
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.current.next();
    }
}

