/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.groups;

import java.util.Iterator;
import java.util.Map;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.delegates.Delegate;
import net.emaze.dysfunctional.dispatching.delegates.Provider;

public class IndexBy<M extends Map<K, V>, K, V>
implements Delegate<M, Iterator<V>> {
    private final Delegate<K, V> grouper;
    private final Provider<M> mapProvider;

    public IndexBy(Delegate<K, V> grouper, Provider<M> mapProvider) {
        dbc.precondition(grouper != null, "cannot index with a null grouper", new Object[0]);
        dbc.precondition(mapProvider != null, "cannot index with a null mapProvider", new Object[0]);
        this.grouper = grouper;
        this.mapProvider = mapProvider;
    }

    @Override
    public M perform(Iterator<V> groupies) {
        dbc.precondition(groupies != null, "cannot index with a null iterator", new Object[0]);
        Map grouped = (Map)this.mapProvider.provide();
        while (groupies.hasNext()) {
            V groupie = groupies.next();
            K group = this.grouper.perform(groupie);
            grouped.put(group, groupie);
        }
        return (M)grouped;
    }
}

