/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.dispatching.spying;

import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.logic.BinaryPredicate;
import net.emaze.dysfunctional.options.Box;

public class BinaryCapturingPredicate<T1, T2>
implements BinaryPredicate<T1, T2> {
    private final BinaryPredicate<T1, T2> nested;
    private final Box<Boolean> result;
    private final Box<T1> param1;
    private final Box<T2> param2;

    public BinaryCapturingPredicate(BinaryPredicate<T1, T2> nested, Box<Boolean> result, Box<T1> param1, Box<T2> param2) {
        dbc.precondition(nested != null, "cannot capture from a null predicate", new Object[0]);
        dbc.precondition(result != null, "cannot capture with a null result box", new Object[0]);
        dbc.precondition(param1 != null, "cannot capture with a null param1 box", new Object[0]);
        dbc.precondition(param2 != null, "cannot capture with a null param2 box", new Object[0]);
        this.nested = nested;
        this.result = result;
        this.param1 = param1;
        this.param2 = param2;
    }

    @Override
    public boolean accept(T1 former, T2 latter) {
        this.param1.setContent(former);
        this.param2.setContent(latter);
        boolean got = this.nested.accept(former, latter);
        this.result.setContent(got);
        return got;
    }
}

