/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.dispatching.delegates;

import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.delegates.Delegate;
import net.emaze.dysfunctional.dispatching.delegates.TernaryDelegate;

public class TernaryComposer<R, T1, T2, T3, T4>
implements TernaryDelegate<R, T2, T3, T4> {
    private final Delegate<R, T1> unary;
    private final TernaryDelegate<T1, T2, T3, T4> ternary;

    public TernaryComposer(Delegate<R, T1> unary, TernaryDelegate<T1, T2, T3, T4> ternary) {
        dbc.precondition(unary != null, "cannot compose a null unary delegate", new Object[0]);
        dbc.precondition(ternary != null, "cannot compose a null ternary delegate", new Object[0]);
        this.unary = unary;
        this.ternary = ternary;
    }

    @Override
    public R perform(T2 first, T3 second, T4 third) {
        return this.unary.perform(this.ternary.perform(first, second, third));
    }
}

