/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional;

import java.util.Iterator;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.adapting.IgnoreParameter;
import net.emaze.dysfunctional.dispatching.delegates.Delegate;
import net.emaze.dysfunctional.dispatching.delegates.Provider;
import net.emaze.dysfunctional.filtering.DropWhile;
import net.emaze.dysfunctional.filtering.FilteringIterator;
import net.emaze.dysfunctional.filtering.UntilCount;
import net.emaze.dysfunctional.iterations.ArrayIterable;
import net.emaze.dysfunctional.iterations.ArrayIterator;
import net.emaze.dysfunctional.iterations.EmptyIterable;
import net.emaze.dysfunctional.iterations.EmptyIterator;
import net.emaze.dysfunctional.iterations.IteratorGenerator;
import net.emaze.dysfunctional.iterations.OneTimeIterable;
import net.emaze.dysfunctional.iterations.SingletonIterable;
import net.emaze.dysfunctional.iterations.SingletonIterator;
import net.emaze.dysfunctional.options.Maybe;

public abstract class Iterations {
    public static <T> Iterable<T> oneTime(Iterator<T> iterator) {
        return new OneTimeIterable<T>(iterator);
    }

    public static <T> Iterator<T> iterator() {
        return new EmptyIterator();
    }

    public static <T> Iterator<T> iterator(T value) {
        return new SingletonIterator<T>(value);
    }

    public static <T> Iterator<T> iterator(T first, T second) {
        return ArrayIterator.of(first, second);
    }

    public static <T> Iterator<T> iterator(T first, T second, T third) {
        return ArrayIterator.of(first, second, third);
    }

    public static <T> Iterator<T> iterator(T ... values) {
        return new ArrayIterator<T>(values);
    }

    public static <T> Iterator<T> iterator(Provider<Maybe<T>> generator) {
        dbc.precondition(generator != null, "generator cannot be null", new Object[0]);
        IteratorGenerator<Object> iterator = new IteratorGenerator<Object>(null, new IgnoreParameter(generator));
        return new FilteringIterator<Object>(iterator, new DropWhile(new UntilCount(1L)));
    }

    public static <T> Iterator<T> iterator(T seed, Delegate<Maybe<T>, T> generator) {
        return new IteratorGenerator<T>(seed, generator);
    }

    public static <T> Iterable<T> iterable() {
        return new EmptyIterable();
    }

    public static <T> Iterable<T> iterable(T value) {
        return new SingletonIterable<T>(value);
    }

    public static <T> Iterable<T> iterable(T first, T second) {
        return ArrayIterable.of(first, second);
    }

    public static <T> Iterable<T> iterable(T first, T second, T third) {
        return ArrayIterable.of(first, second, third);
    }

    public static <T> Iterable<T> iterable(T ... values) {
        return new ArrayIterable<T>(values);
    }
}

