/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional;

import net.emaze.dysfunctional.contracts.dbc;

public abstract class Boxing {
    public static Boolean[] box(boolean[] array) {
        dbc.precondition(array != null, "cannot box a null boolean array", new Object[0]);
        Boolean[] result = new Boolean[array.length];
        for (int i = 0; i != result.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static Byte[] box(byte[] array) {
        dbc.precondition(array != null, "cannot box a null byte array", new Object[0]);
        Byte[] result = new Byte[array.length];
        for (int i = 0; i != result.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static Character[] box(char[] array) {
        dbc.precondition(array != null, "cannot box a null char array", new Object[0]);
        Character[] result = new Character[array.length];
        for (int i = 0; i != result.length; ++i) {
            result[i] = Character.valueOf(array[i]);
        }
        return result;
    }

    public static Short[] box(short[] array) {
        dbc.precondition(array != null, "cannot box a null short array", new Object[0]);
        Short[] result = new Short[array.length];
        for (int i = 0; i != result.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static Integer[] box(int[] array) {
        dbc.precondition(array != null, "cannot box a null int array", new Object[0]);
        Integer[] result = new Integer[array.length];
        for (int i = 0; i != result.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static Long[] box(long[] array) {
        dbc.precondition(array != null, "cannot box a null long array", new Object[0]);
        Long[] result = new Long[array.length];
        for (int i = 0; i != result.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static Float[] box(float[] array) {
        dbc.precondition(array != null, "cannot box a null float array", new Object[0]);
        Float[] result = new Float[array.length];
        for (int i = 0; i != result.length; ++i) {
            result[i] = Float.valueOf(array[i]);
        }
        return result;
    }

    public static Double[] box(double[] array) {
        dbc.precondition(array != null, "cannot box a null double array", new Object[0]);
        Double[] result = new Double[array.length];
        for (int i = 0; i != result.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static boolean[] unbox(Boolean[] array) {
        dbc.precondition(array != null, "cannot unbox a null Boolean array", new Object[0]);
        boolean[] result = new boolean[array.length];
        for (int i = 0; i != result.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static byte[] unbox(Byte[] array) {
        dbc.precondition(array != null, "cannot unbox a null Byte array", new Object[0]);
        byte[] result = new byte[array.length];
        for (int i = 0; i != result.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static char[] unbox(Character[] array) {
        dbc.precondition(array != null, "cannot unbox a null Character array", new Object[0]);
        char[] result = new char[array.length];
        for (int i = 0; i != result.length; ++i) {
            result[i] = array[i].charValue();
        }
        return result;
    }

    public static short[] unbox(Short[] array) {
        dbc.precondition(array != null, "cannot unbox a null Short array", new Object[0]);
        short[] result = new short[array.length];
        for (int i = 0; i != result.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static int[] unbox(Integer[] array) {
        dbc.precondition(array != null, "cannot unbox a null Integer array", new Object[0]);
        int[] result = new int[array.length];
        for (int i = 0; i != result.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static long[] unbox(Long[] array) {
        dbc.precondition(array != null, "cannot unbox a null Long array", new Object[0]);
        long[] result = new long[array.length];
        for (int i = 0; i != result.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static float[] unbox(Float[] array) {
        dbc.precondition(array != null, "cannot unbox a null Float array", new Object[0]);
        float[] result = new float[array.length];
        for (int i = 0; i != result.length; ++i) {
            result[i] = array[i].floatValue();
        }
        return result;
    }

    public static double[] unbox(Double[] array) {
        dbc.precondition(array != null, "cannot unbox a null Double array", new Object[0]);
        double[] result = new double[array.length];
        for (int i = 0; i != result.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }
}

