/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.time;

import java.util.concurrent.TimeUnit;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.delegates.Provider;
import net.emaze.dysfunctional.time.TimeStrategy;
import net.emaze.dysfunctional.tuples.Pair;

public class TimeStrategyToMillisProvider
implements Provider<Long> {
    private final TimeStrategy timeStrategy;

    public TimeStrategyToMillisProvider(TimeStrategy timeStrategy) {
        dbc.precondition(timeStrategy != null, "cannot create a MillisProvider with a null timeStrategy", new Object[0]);
        this.timeStrategy = timeStrategy;
    }

    @Override
    public Long provide() {
        Pair<Long, TimeUnit> currentTime = this.timeStrategy.currentTime();
        return TimeUnit.MILLISECONDS.convert(currentTime.first(), currentTime.second());
    }
}

