/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.options;

import java.util.Iterator;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.delegates.Delegate;
import net.emaze.dysfunctional.dispatching.delegates.Provider;
import net.emaze.dysfunctional.equality.EqualsBuilder;
import net.emaze.dysfunctional.hashing.HashCodeBuilder;
import net.emaze.dysfunctional.iterations.EmptyIterator;
import net.emaze.dysfunctional.iterations.SingletonIterator;
import net.emaze.dysfunctional.options.Either;

public class Maybe<E>
implements Iterable<E> {
    private final E element;
    private final boolean hasValue;
    private static Maybe<Object> NOTHING = new Maybe<Object>(null, false);

    public Maybe(E element, boolean hasValue) {
        this.element = element;
        this.hasValue = hasValue;
    }

    public boolean hasValue() {
        return this.hasValue;
    }

    public E value() {
        dbc.state(this.hasValue, "fetching value from nothing", new Object[0]);
        return this.element;
    }

    public <T> Maybe<T> fmap(Delegate<T, E> delegate) {
        dbc.precondition(delegate != null, "cannot perform fmap with a null delegate", new Object[0]);
        if (this.hasValue) {
            return Maybe.just(delegate.perform(this.element));
        }
        return Maybe.nothing();
    }

    public <T> Either<T, E> either(Provider<T> nothing) {
        if (this.hasValue) {
            return Either.right(this.element);
        }
        return Either.left(nothing.provide());
    }

    public E orElse(E otherwise) {
        if (this.hasValue) {
            return this.element;
        }
        return otherwise;
    }

    public Maybe<E> orElse(Maybe<E> otherwise) {
        if (this.hasValue) {
            return this;
        }
        return otherwise;
    }

    public static <E> Maybe<E> nothing() {
        return NOTHING;
    }

    public static <E> Maybe<E> just(E element) {
        return new Maybe<E>(element, true);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.hasValue).append(this.element).toHashCode();
    }

    public boolean equals(Object rhs) {
        if (!(rhs instanceof Maybe)) {
            return false;
        }
        Maybe other = (Maybe)rhs;
        return new EqualsBuilder().append(this.hasValue, other.hasValue).append(this.element, other.element).isEquals();
    }

    public String toString() {
        if (!this.hasValue) {
            return "Nothing";
        }
        return String.format("Just %s", this.element);
    }

    @Override
    public Iterator<E> iterator() {
        if (!this.hasValue) {
            return new EmptyIterator();
        }
        return new SingletonIterator<E>(this.element);
    }
}

