/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.interceptions;

import java.util.Iterator;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.delegates.Delegate;
import net.emaze.dysfunctional.interceptions.Interceptor;
import net.emaze.dysfunctional.interceptions.InterceptorAdapter;

public class InterceptorChain<R, T>
implements Delegate<R, T> {
    private final Delegate<R, T> composed;

    public <I extends Interceptor<T>> InterceptorChain(Delegate<R, T> innermost, Iterator<I> chain) {
        dbc.precondition(innermost != null, "innermost delegate cannot be null", new Object[0]);
        dbc.precondition(chain != null, "chain cannot be null", new Object[0]);
        Delegate<R, T> current = innermost;
        while (chain.hasNext()) {
            current = new InterceptorAdapter<R, T>((Interceptor)chain.next(), current);
        }
        this.composed = current;
    }

    @Override
    public R perform(T param) {
        return this.composed.perform(param);
    }
}

