/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.dispatching.spying;

import java.util.concurrent.atomic.AtomicLong;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.delegates.Delegate;

public class MonitoringDelegate<R, T>
implements Delegate<R, T> {
    private final Delegate<R, T> nested;
    private final AtomicLong calls;

    public MonitoringDelegate(Delegate<R, T> nested, AtomicLong calls) {
        dbc.precondition(nested != null, "cannot monitor a null delegate", new Object[0]);
        dbc.precondition(calls != null, "cannot monitor with a null AtomicLong", new Object[0]);
        this.nested = nested;
        this.calls = calls;
    }

    @Override
    public R perform(T value) {
        this.calls.incrementAndGet();
        return this.nested.perform(value);
    }
}

