/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.dispatching.spying;

import java.util.concurrent.atomic.AtomicLong;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.actions.BinaryAction;

public class BinaryMonitoringAction<T1, T2>
implements BinaryAction<T1, T2> {
    private final BinaryAction<T1, T2> nested;
    private final AtomicLong calls;

    public BinaryMonitoringAction(BinaryAction<T1, T2> nested, AtomicLong calls) {
        dbc.precondition(nested != null, "cannot monitor a null action", new Object[0]);
        dbc.precondition(calls != null, "cannot monitor with a null AtomicLong", new Object[0]);
        this.nested = nested;
        this.calls = calls;
    }

    @Override
    public void perform(T1 former, T2 latter) {
        this.calls.incrementAndGet();
        this.nested.perform(former, latter);
    }
}

