/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.consumers;

import java.util.Collection;
import java.util.Iterator;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.delegates.Delegate;
import net.emaze.dysfunctional.dispatching.delegates.Provider;

public class ConsumeIntoCollection<R extends Collection<E>, E>
implements Delegate<R, Iterator<E>> {
    private final Provider<R> provider;

    public ConsumeIntoCollection(Provider<R> provider) {
        dbc.precondition(provider != null, "collection provider cannot be null", new Object[0]);
        this.provider = provider;
    }

    @Override
    public R perform(Iterator<E> consumable) {
        dbc.precondition(consumable != null, "consuming a null iterator", new Object[0]);
        Collection out = (Collection)this.provider.provide();
        while (consumable.hasNext()) {
            out.add(consumable.next());
        }
        return (R)out;
    }
}

