/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.windows;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.delegates.Provider;
import net.emaze.dysfunctional.iterations.ReadOnlyIterator;

public class PreciseWindowIterator<W extends Collection<T>, T>
extends ReadOnlyIterator<W> {
    private final Iterator<T> iter;
    private final int windowSize;
    private final Provider<W> provider;
    private final Queue<T> window = new LinkedList<T>();

    public PreciseWindowIterator(Iterator<T> iter, int windowSize, Provider<W> provider) {
        dbc.precondition(iter != null, "cannot create a PreciseWindowIterator with a null iterator", new Object[0]);
        dbc.precondition(windowSize > 0, "cannot create a PreciseWindowIterator with a non positive window size", new Object[0]);
        dbc.precondition(provider != null, "cannot create a CenteredWindowIterator with an null provider", new Object[0]);
        this.iter = iter;
        this.windowSize = windowSize;
        this.provider = provider;
    }

    @Override
    public boolean hasNext() {
        if (this.window.size() == this.windowSize) {
            return true;
        }
        this.tryFillWindow();
        return this.window.size() == this.windowSize;
    }

    @Override
    public W next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("iterator is consumed");
        }
        Collection collection = (Collection)this.provider.provide();
        collection.addAll(this.window);
        this.window.remove();
        return (W)collection;
    }

    private void tryFillWindow() {
        while (this.window.size() != this.windowSize) {
            if (!this.iter.hasNext()) {
                return;
            }
            this.window.add(this.iter.next());
        }
    }
}

