/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.tuples;

import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.delegates.Delegate;
import net.emaze.dysfunctional.tuples.Pair;

public class FmapPair<R1, R2, T1, T2>
implements Delegate<Pair<R1, R2>, Pair<T1, T2>> {
    private final Delegate<R1, T1> first;
    private final Delegate<R2, T2> second;

    public FmapPair(Delegate<R1, T1> first, Delegate<R2, T2> second) {
        dbc.precondition(first != null, "cannot create FmapPair with a null first delegate", new Object[0]);
        dbc.precondition(second != null, "cannot create FmapPair with a null second delegate", new Object[0]);
        this.first = first;
        this.second = second;
    }

    @Override
    public Pair<R1, R2> perform(Pair<T1, T2> from) {
        dbc.precondition(from != null, "cannot fmap a null pair", new Object[0]);
        return from.fmap(this.first, this.second);
    }
}

