/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.strings.lexcasts;

import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.delegates.Delegate;

public class IntegerParser
implements Delegate<Integer, String> {
    private final int radix;

    public IntegerParser(int radix) {
        dbc.precondition(radix >= 2, "radix should be in range [MIN_RADIX, MAX_RADIX]", new Object[0]);
        dbc.precondition(radix <= 36, "radix should be in range [MIN_RADIX, MAX_RADIX]", new Object[0]);
        this.radix = radix;
    }

    @Override
    public Integer perform(String parsee) {
        dbc.precondition(parsee != null, "cannot parse a null string", new Object[0]);
        return Integer.parseInt(parsee, this.radix);
    }
}

