/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.strings;

import java.util.Iterator;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.delegates.Delegate;
import net.emaze.dysfunctional.iterations.ArrayIterator;
import net.emaze.dysfunctional.iterations.SingletonIterator;
import net.emaze.dysfunctional.iterations.TransformingIterator;
import net.emaze.dysfunctional.strings.InterposeStrings;
import net.emaze.dysfunctional.strings.ToLowerCase;

public class WordsToLowerSnakeCase
implements Delegate<String, String[]> {
    private final ToLowerCase toLower = new ToLowerCase();
    private final String snakeGlyph;

    public WordsToLowerSnakeCase(String snakeGlyph) {
        dbc.precondition(snakeGlyph != null, "cannot create WordsToLowerSnakeCase with a null snakeGlyph", new Object[0]);
        this.snakeGlyph = snakeGlyph;
    }

    @Override
    public String perform(String[] words) {
        dbc.precondition(words != null, "cannot lowerSnakeCase a null array of words", new Object[0]);
        TransformingIterator<String, String> values = new TransformingIterator<String, String>(new ArrayIterator<String>(words), this.toLower);
        return new InterposeStrings().perform(values, (Iterator<String>)new SingletonIterator<String>(this.snakeGlyph));
    }
}

