/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.multiplexing;

import java.util.Collection;
import java.util.Iterator;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.delegates.Provider;
import net.emaze.dysfunctional.iterations.ReadOnlyIterator;
import net.emaze.dysfunctional.options.Maybe;
import net.emaze.dysfunctional.options.MaybeIterator;

public class UnchainWithExactChannelSizeIterator<C extends Collection<Maybe<T>>, T>
extends ReadOnlyIterator<C> {
    private final Iterator<Maybe<T>> iterator;
    private final Provider<Maybe<Integer>> channelsSizesProvider;
    private final Provider<C> channelProvider;

    public UnchainWithExactChannelSizeIterator(Provider<Maybe<Integer>> channelsSizesProvider, Iterator<T> iterator, Provider<C> channelProvider) {
        dbc.precondition(channelsSizesProvider != null, "cannot build a UnchainWithExactChannelSizeIterator with channelsSizesProvider < 1", new Object[0]);
        dbc.precondition(iterator != null, "cannot build a UnchainWithExactChannelSizeIterator with a null iterator", new Object[0]);
        dbc.precondition(channelProvider != null, "cannot build a UnchainWithExactChannelSizeIterator with a null channelProvider", new Object[0]);
        this.iterator = new MaybeIterator<T>(iterator);
        this.channelsSizesProvider = channelsSizesProvider;
        this.channelProvider = channelProvider;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public C next() {
        Collection out = (Collection)this.channelProvider.provide();
        Maybe<Integer> maybeChannelSize = this.channelsSizesProvider.provide();
        dbc.state(maybeChannelSize.hasValue(), "unexpected channel size request (provider returned Nothing)", new Object[0]);
        int channelSize = maybeChannelSize.value();
        for (int i = 0; i != channelSize; ++i) {
            out.add(this.iterator.next());
        }
        return (C)out;
    }
}

