/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.iterations;

import java.util.Iterator;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.delegates.Delegate;

public class TransformingIterator<R, T>
implements Iterator<R> {
    private final Delegate<R, T> transformer;
    private final Iterator<T> iterator;

    public TransformingIterator(Iterator<T> iterator, Delegate<R, T> transformer) {
        dbc.precondition(iterator != null, "trying to create a TransformingIterator from a null iterator", new Object[0]);
        dbc.precondition(transformer != null, "trying to create a TransformingIterator with a null transformer", new Object[0]);
        this.iterator = iterator;
        this.transformer = transformer;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public R next() {
        return this.transformer.perform(this.iterator.next());
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }
}

