/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.collections.builders;

import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.delegates.Provider;

public class NestedMapBuilder<K> {
    private final Deque<K> stack = new LinkedList<K>();
    private final Provider<Map<K, Object>> provider;
    private final Map<K, Object> buildee;
    public final NestedMapBuilder<K> ___;

    public NestedMapBuilder(Provider<Map<K, Object>> provider) {
        dbc.precondition(provider != null, "cannot create a MapTreeBuilder with a null map provider", new Object[0]);
        this.provider = provider;
        this.buildee = provider.provide();
        this.___ = this;
    }

    public NestedMapBuilder<K> add(Map<K, ? extends Object> map) {
        dbc.precondition(map != null, "cannot merge a null map", new Object[0]);
        this.current().putAll(map);
        return this;
    }

    public NestedMapBuilder<K> add(K key, Object value) {
        this.current().put(key, value);
        return this;
    }

    public NestedMapBuilder<K> push(K key) {
        this.current().put(key, this.provider.provide());
        this.stack.addLast(key);
        return this;
    }

    public NestedMapBuilder<K> pop() {
        dbc.precondition(this.stack.size() != 0, "popping from an empty stack", new Object[0]);
        this.stack.removeLast();
        return this;
    }

    public Map<K, Object> toMap() {
        return this.buildee;
    }

    public Map<K, Object> toUnmodifiableMap() {
        return Collections.unmodifiableMap(this.buildee);
    }

    private Map<K, Object> current() {
        Map current = this.buildee;
        for (K nested : this.stack) {
            current = (Map)current.get(nested);
        }
        return current;
    }
}

