/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.emaze.dysfunctional.Compositions;
import net.emaze.dysfunctional.casts.Vary;
import net.emaze.dysfunctional.collections.ArrayListFactory;
import net.emaze.dysfunctional.collections.HashMapFactory;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.delegates.Delegate;
import net.emaze.dysfunctional.dispatching.delegates.Provider;
import net.emaze.dysfunctional.dispatching.logic.Predicate;
import net.emaze.dysfunctional.groups.GroupBy;
import net.emaze.dysfunctional.groups.IndexBy;
import net.emaze.dysfunctional.groups.PartitionBy;
import net.emaze.dysfunctional.iterations.ArrayIterator;
import net.emaze.dysfunctional.tuples.Pair;

public abstract class Groups {
    public static <K, V> Map<K, List<V>> groupBy(Iterator<V> groupies, Delegate<K, V> grouper) {
        Provider provider = Compositions.compose(new Vary(), new ArrayListFactory());
        return new GroupBy(grouper, provider, new HashMapFactory()).perform(groupies);
    }

    public static <C extends Collection<V>, K, V> Map<K, C> groupBy(Iterator<V> groupies, Delegate<K, V> grouper, Provider<C> collectionProvider) {
        return new GroupBy(grouper, collectionProvider, new HashMapFactory()).perform(groupies);
    }

    public static <M extends Map<K, C>, C extends Collection<V>, K, V> Map<K, C> groupBy(Iterator<V> groupies, Delegate<K, V> grouper, Provider<C> collectionProvider, Provider<M> mapProvider) {
        return new GroupBy<M, C, K, V>(grouper, collectionProvider, mapProvider).perform(groupies);
    }

    public static <K, V> Map<K, List<V>> groupBy(Iterable<V> groupies, Delegate<K, V> grouper) {
        dbc.precondition(groupies != null, "cannot group a null iterable", new Object[0]);
        Provider provider = Compositions.compose(new Vary(), new ArrayListFactory());
        return new GroupBy(grouper, provider, new HashMapFactory()).perform(groupies.iterator());
    }

    public static <C extends Collection<V>, K, V> Map<K, C> groupBy(Iterable<V> groupies, Delegate<K, V> grouper, Provider<C> collectionProvider) {
        dbc.precondition(groupies != null, "cannot group a null iterable", new Object[0]);
        return new GroupBy(grouper, collectionProvider, new HashMapFactory()).perform(groupies.iterator());
    }

    public static <M extends Map<K, C>, C extends Collection<V>, K, V> Map<K, C> groupBy(Iterable<V> groupies, Delegate<K, V> grouper, Provider<C> collectionProvider, Provider<M> mapProvider) {
        dbc.precondition(groupies != null, "cannot group a null iterable", new Object[0]);
        return new GroupBy<M, C, K, V>(grouper, collectionProvider, mapProvider).perform(groupies.iterator());
    }

    public static <K, V> Map<K, List<V>> groupBy(V[] groupies, Delegate<K, V> grouper) {
        Provider provider = Compositions.compose(new Vary(), new ArrayListFactory());
        return new GroupBy(grouper, provider, new HashMapFactory()).perform((Iterator<V>)new ArrayIterator<V>(groupies));
    }

    public static <C extends Collection<V>, K, V> Map<K, C> groupBy(V[] groupies, Delegate<K, V> grouper, Provider<C> collectionProvider) {
        return new GroupBy(grouper, collectionProvider, new HashMapFactory()).perform((Iterator<V>)new ArrayIterator<V>(groupies));
    }

    public static <M extends Map<K, C>, C extends Collection<V>, K, V> Map<K, C> groupBy(V[] groupies, Delegate<K, V> grouper, Provider<C> collectionProvider, Provider<M> mapProvider) {
        return new GroupBy<M, C, K, V>(grouper, collectionProvider, mapProvider).perform((Iterator<V>)new ArrayIterator<V>(groupies));
    }

    public static <T> Pair<List<T>, List<T>> partition(Iterator<T> values, Predicate<T> partitioner) {
        Provider provider = Compositions.compose(new Vary(), new ArrayListFactory());
        return new PartitionBy(partitioner, provider, provider).perform(values);
    }

    public static <C extends Collection<T>, T> Pair<C, C> partition(Iterator<T> values, Predicate<T> partitioner, Provider<C> collectionsProvider) {
        return new PartitionBy<C, C, T>(partitioner, collectionsProvider, collectionsProvider).perform(values);
    }

    public static <CA extends Collection<T>, CR extends Collection<T>, T> Pair<CA, CR> partition(Iterator<T> values, Predicate<T> partitioner, Provider<CA> acceptedCollectionProvider, Provider<CR> refusedCollectionProvider) {
        return new PartitionBy<CA, CR, T>(partitioner, acceptedCollectionProvider, refusedCollectionProvider).perform(values);
    }

    public static <T> Pair<List<T>, List<T>> partition(Iterable<T> values, Predicate<T> partitioner) {
        dbc.precondition(values != null, "cannot partition a null iterable", new Object[0]);
        Provider provider = Compositions.compose(new Vary(), new ArrayListFactory());
        return new PartitionBy(partitioner, provider, provider).perform(values.iterator());
    }

    public static <C extends Collection<T>, T> Pair<C, C> partition(Iterable<T> values, Predicate<T> partitioner, Provider<C> collectionsProvider) {
        dbc.precondition(values != null, "cannot partition a null iterable", new Object[0]);
        return new PartitionBy<C, C, T>(partitioner, collectionsProvider, collectionsProvider).perform(values.iterator());
    }

    public static <CA extends Collection<T>, CR extends Collection<T>, T> Pair<CA, CR> partition(Iterable<T> values, Predicate<T> partitioner, Provider<CA> acceptedCollectionProvider, Provider<CR> refusedCollectionProvider) {
        dbc.precondition(values != null, "cannot partition a null iterable", new Object[0]);
        return new PartitionBy<CA, CR, T>(partitioner, acceptedCollectionProvider, refusedCollectionProvider).perform(values.iterator());
    }

    public static <T> Pair<List<T>, List<T>> partition(T[] values, Predicate<T> partitioner) {
        Provider provider = Compositions.compose(new Vary(), new ArrayListFactory());
        return new PartitionBy(partitioner, provider, provider).perform(new ArrayIterator<T>(values));
    }

    public static <C extends Collection<T>, T> Pair<C, C> partition(T[] values, Predicate<T> partitioner, Provider<C> collectionsProvider) {
        return new PartitionBy<C, C, T>(partitioner, collectionsProvider, collectionsProvider).perform(new ArrayIterator<T>(values));
    }

    public static <CA extends Collection<T>, CR extends Collection<T>, T> Pair<CA, CR> partition(T[] values, Predicate<T> partitioner, Provider<CA> acceptedCollectionProvider, Provider<CR> refusedCollectionProvider) {
        return new PartitionBy<CA, CR, T>(partitioner, acceptedCollectionProvider, refusedCollectionProvider).perform(new ArrayIterator<T>(values));
    }

    public static <M extends Map<K, V>, K, V> Map<K, V> indexBy(Iterable<V> groupies, Delegate<K, V> indexer, Provider<M> mapProvider) {
        dbc.precondition(groupies != null, "cannot index from a null iterable", new Object[0]);
        return new IndexBy<M, K, V>(indexer, mapProvider).perform(groupies.iterator());
    }

    public static <K, V> Map<K, V> indexBy(Iterable<V> groupies, Delegate<K, V> indexer) {
        dbc.precondition(groupies != null, "cannot index from a null iterable", new Object[0]);
        return new IndexBy(indexer, new HashMapFactory()).perform(groupies.iterator());
    }

    public static <M extends Map<K, V>, K, V> Map<K, V> indexBy(Iterator<V> groupies, Delegate<K, V> indexer, Provider<M> mapProvider) {
        return new IndexBy<M, K, V>(indexer, mapProvider).perform(groupies);
    }

    public static <K, V> Map<K, V> indexBy(Iterator<V> groupies, Delegate<K, V> indexer) {
        return new IndexBy(indexer, new HashMapFactory()).perform(groupies);
    }

    public static <M extends Map<K, V>, K, V> Map<K, V> indexBy(V[] groupies, Delegate<K, V> indexer, Provider<M> mapProvider) {
        return new IndexBy<M, K, V>(indexer, mapProvider).perform((Iterator<V>)new ArrayIterator<V>(groupies));
    }

    public static <K, V> Map<K, V> indexBy(V[] groupies, Delegate<K, V> indexer) {
        return new IndexBy(indexer, new HashMapFactory()).perform((Iterator<V>)new ArrayIterator<V>(groupies));
    }
}

