/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.windows;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.delegates.Provider;
import net.emaze.dysfunctional.iterations.ReadOnlyIterator;
import net.emaze.dysfunctional.options.Maybe;

public class CenteredWindowIterator<W extends Collection<Maybe<T>>, T>
extends ReadOnlyIterator<W> {
    private final Iterator<T> iter;
    private final int windowSize;
    private final Provider<W> provider;
    private final LinkedList<Maybe<T>> window = new LinkedList();
    private boolean freshIterator = true;

    public CenteredWindowIterator(Iterator<T> iter, int windowSize, Provider<W> provider) {
        dbc.precondition(iter != null, "cannot create a CenteredWindowIterator with a null iterator", new Object[0]);
        dbc.precondition(windowSize > 2, "cannot create a CenteredWindowIterator with a non positive or 1 window size", new Object[0]);
        dbc.precondition(windowSize % 2 == 1, "cannot create a CenteredWindowIterator with an even windowSize", new Object[0]);
        dbc.precondition(provider != null, "cannot create a CenteredWindowIterator with an null provider", new Object[0]);
        this.iter = iter;
        this.windowSize = windowSize;
        this.provider = provider;
        for (int i = 0; i != windowSize / 2; ++i) {
            this.window.add(Maybe.nothing());
        }
    }

    @Override
    public boolean hasNext() {
        this.fillWindow();
        return !this.isConsumed();
    }

    @Override
    public W next() {
        this.fillWindow();
        if (this.isConsumed()) {
            throw new NoSuchElementException("iterator is consumed");
        }
        if (!this.freshIterator) {
            this.window.remove();
        }
        this.freshIterator = false;
        this.fillWindow();
        Collection collection = (Collection)this.provider.provide();
        collection.addAll(this.window);
        return (W)collection;
    }

    private boolean isConsumed() {
        if (this.freshIterator) {
            return !this.center().hasValue();
        }
        return !this.nextOfCenter().hasValue();
    }

    private Maybe<T> nextOfCenter() {
        return this.window.get(this.windowSize / 2 + 1);
    }

    private Maybe<T> center() {
        return this.window.get(this.windowSize / 2);
    }

    private void fillWindow() {
        while (this.window.size() != this.windowSize) {
            Maybe maybe = this.iter.hasNext() ? Maybe.just(this.iter.next()) : Maybe.nothing();
            this.window.add(maybe);
        }
    }
}

