/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.tuples;

import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.delegates.Delegate;
import net.emaze.dysfunctional.equality.EqualsBuilder;
import net.emaze.dysfunctional.hashing.HashCodeBuilder;

public class Pair<T1, T2> {
    private final T1 first;
    private final T2 second;

    public Pair(T1 f, T2 l) {
        this.first = f;
        this.second = l;
    }

    public T1 first() {
        return this.first;
    }

    public T2 second() {
        return this.second;
    }

    public <R1, R2> Pair<R1, R2> fmap(Delegate<R1, T1> withFirst, Delegate<R2, T2> withSecond) {
        dbc.precondition(withFirst != null, "cannot fmap on pair with a null first delegate", new Object[0]);
        dbc.precondition(withSecond != null, "cannot fmap on pair with a null second delegate", new Object[0]);
        return Pair.of(withFirst.perform(this.first), withSecond.perform(this.second));
    }

    public boolean equals(Object rhs) {
        if (!(rhs instanceof Pair)) {
            return false;
        }
        Pair other = (Pair)rhs;
        return new EqualsBuilder().append(this.first, other.first).append(this.second, other.second).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.first).append(this.second).toHashCode();
    }

    public String toString() {
        return String.format("(%s,%s)", this.first, this.second);
    }

    public static <T1, T2> Pair<T1, T2> of(T1 first, T2 second) {
        return new Pair<T1, T2>(first, second);
    }
}

