/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.strings.lexcasts;

import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.delegates.Delegate;

public class ShortParser
implements Delegate<Short, String> {
    private final int radix;

    public ShortParser(int radix) {
        dbc.precondition(radix >= 2, "radix should be in range [MIN_RADIX, MAX_RADIX]", new Object[0]);
        dbc.precondition(radix <= 36, "radix should be in range [MIN_RADIX, MAX_RADIX]", new Object[0]);
        this.radix = radix;
    }

    @Override
    public Short perform(String parsee) {
        dbc.precondition(parsee != null, "cannot parse a null string", new Object[0]);
        return Short.parseShort(parsee, this.radix);
    }
}

