/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.strings.lexcasts;

import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.delegates.Delegate;
import net.emaze.dysfunctional.options.Maybe;

public class LongTryParser
implements Delegate<Maybe<Long>, String> {
    private final int radix;

    public LongTryParser(int radix) {
        dbc.precondition(radix >= 2, "radix should be in range [MIN_RADIX, MAX_RADIX]", new Object[0]);
        dbc.precondition(radix <= 36, "radix should be in range [MIN_RADIX, MAX_RADIX]", new Object[0]);
        this.radix = radix;
    }

    @Override
    public Maybe<Long> perform(String parsee) {
        try {
            return Maybe.just(Long.parseLong(parsee, this.radix));
        }
        catch (NumberFormatException ex) {
            return Maybe.nothing();
        }
    }
}

