/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.strings.lexcasts;

import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.delegates.Delegate;
import net.emaze.dysfunctional.options.Maybe;

public class IntegerTryParser
implements Delegate<Maybe<Integer>, String> {
    private final int radix;

    public IntegerTryParser(int radix) {
        dbc.precondition(radix >= 2, "radix should be in range [MIN_RADIX, MAX_RADIX]", new Object[0]);
        dbc.precondition(radix <= 36, "radix should be in range [MIN_RADIX, MAX_RADIX]", new Object[0]);
        this.radix = radix;
    }

    @Override
    public Maybe<Integer> perform(String parsee) {
        try {
            return Maybe.just(Integer.parseInt(parsee, this.radix));
        }
        catch (NumberFormatException ex) {
            return Maybe.nothing();
        }
    }
}

