/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.strings;

import java.util.Iterator;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.delegates.Delegate;
import net.emaze.dysfunctional.iterations.ArrayIterator;
import net.emaze.dysfunctional.iterations.SingletonIterator;
import net.emaze.dysfunctional.iterations.TransformingIterator;
import net.emaze.dysfunctional.strings.InterposeStrings;
import net.emaze.dysfunctional.strings.ToUpperCase;

public class WordsToUpperSnakeCase
implements Delegate<String, String[]> {
    private final ToUpperCase toUpper = new ToUpperCase();
    private final String snakeGlyph;

    public WordsToUpperSnakeCase(String snakeGlyph) {
        dbc.precondition(snakeGlyph != null, "cannot create WordsToUpperSnakeCase with a null snakeGlyph", new Object[0]);
        this.snakeGlyph = snakeGlyph;
    }

    @Override
    public String perform(String[] words) {
        dbc.precondition(words != null, "cannot upperSnakeCase a null array of words", new Object[0]);
        TransformingIterator<String, String> values = new TransformingIterator<String, String>(new ArrayIterator<String>(words), this.toUpper);
        return new InterposeStrings().perform(values, (Iterator<String>)new SingletonIterator<String>(this.snakeGlyph));
    }
}

