/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.ranges;

import java.util.ArrayList;
import java.util.Comparator;
import net.emaze.dysfunctional.dispatching.delegates.BinaryDelegate;
import net.emaze.dysfunctional.options.Maybe;
import net.emaze.dysfunctional.order.MakeOrder;
import net.emaze.dysfunctional.order.SequencingPolicy;
import net.emaze.dysfunctional.ranges.DenseRange;
import net.emaze.dysfunctional.ranges.MakeRange;
import net.emaze.dysfunctional.ranges.Range;
import net.emaze.dysfunctional.tuples.Pair;

public class Intersection<T>
implements BinaryDelegate<Range<T>, Range<T>, Range<T>> {
    private final SequencingPolicy<T> sequencer;
    private final Comparator<Maybe<T>> comparator;
    private final T emptyValue;

    public Intersection(SequencingPolicy<T> sequencer, Comparator<Maybe<T>> comparator, T emptyValue) {
        this.sequencer = sequencer;
        this.comparator = comparator;
        this.emptyValue = emptyValue;
    }

    @Override
    public Range<T> perform(Range<T> lhs, Range<T> rhs) {
        ArrayList intersection = new ArrayList();
        MakeOrder<Maybe<T>> makeOrder = new MakeOrder<Maybe<T>>(this.comparator);
        for (DenseRange<T> l : lhs.densified()) {
            for (DenseRange<T> r : rhs.densified()) {
                if (!l.overlaps(r)) continue;
                Object orderedLowerBounds = makeOrder.perform((Object)Maybe.just(l.begin()), (Object)Maybe.just(r.begin()));
                Object orderedUpperBounds = makeOrder.perform((Object)l.end(), (Object)r.end());
                intersection.add(new DenseRange<T>(this.sequencer, this.comparator, Range.Endpoint.Include, ((Maybe)((Pair)orderedLowerBounds).second()).value(), (Maybe)((Pair)orderedUpperBounds).first(), Range.Endpoint.Exclude));
            }
        }
        return new MakeRange(this.sequencer, this.comparator, this.emptyValue).perform(intersection);
    }
}

